/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.constant.enums;

import com.xforceplus.evat.common.constant.enums.InvoiceTypeEnum;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CostInvoiceTypeEnum {
    SPECIAL_INVOICE("1", InvoiceTypeEnum.SPECIAL_INVOICE),
    GENERAL_INVOICE("2", InvoiceTypeEnum.GENERAL_INVOICE),
    E_INVOICE("5", InvoiceTypeEnum.E_INVOICE),
    ELECTRONIC_INVOICE("6", InvoiceTypeEnum.ELECTRONIC_INVOICE),
    QC_INVOICE("7", InvoiceTypeEnum.QC_INVOICE),
    QS_INVOICE("8", InvoiceTypeEnum.QS_INVOICE);

    private String costInvoiceType;
    private InvoiceTypeEnum invoiceType;

    public static Optional<String> getCostInvoiceType(String invoiceType) {
        return Arrays.stream(CostInvoiceTypeEnum.values()).filter(s -> s.getInvoiceType().getResultCode().equalsIgnoreCase(invoiceType)).findFirst().map(CostInvoiceTypeEnum::getCostInvoiceType);
    }

    public static Optional<InvoiceTypeEnum> getInvoiceType(String costInvoiceType) {
        return Arrays.stream(CostInvoiceTypeEnum.values()).filter(s -> s.costInvoiceType.equalsIgnoreCase(costInvoiceType)).findFirst().map(CostInvoiceTypeEnum::getInvoiceType);
    }

    public static boolean isElectronic(String invoiceType) {
        return Stream.of(E_INVOICE, ELECTRONIC_INVOICE, QC_INVOICE, QS_INVOICE).map(CostInvoiceTypeEnum::getInvoiceType).map(InvoiceTypeEnum::getResultCode).anyMatch(s -> s.equals(invoiceType));
    }

    public static boolean isGeneralInvoice(String invoiceType) {
        return Stream.of(GENERAL_INVOICE, E_INVOICE, QC_INVOICE).map(CostInvoiceTypeEnum::getInvoiceType).map(InvoiceTypeEnum::getResultCode).anyMatch(s -> s.equals(invoiceType));
    }

    public static List<InvoiceTypeEnum> invoiceTypeEnumList() {
        return Stream.of(E_INVOICE, ELECTRONIC_INVOICE, QC_INVOICE, QS_INVOICE, SPECIAL_INVOICE, GENERAL_INVOICE).map(CostInvoiceTypeEnum::getInvoiceType).collect(Collectors.toList());
    }

    public static boolean isInvoice(String invoiceType) {
        return CostInvoiceTypeEnum.invoiceTypeEnumList().stream().map(InvoiceTypeEnum::getResultCode).anyMatch(s -> s.equals(invoiceType));
    }

    private CostInvoiceTypeEnum(String costInvoiceType, InvoiceTypeEnum invoiceType) {
        this.costInvoiceType = costInvoiceType;
        this.invoiceType = invoiceType;
    }

    public String getCostInvoiceType() {
        return this.costInvoiceType;
    }

    public InvoiceTypeEnum getInvoiceType() {
        return this.invoiceType;
    }
}

