/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.tcp;

import com.xforceplus.apollo.client.netty.IMessageListener;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.modules.tcp.GlobalReceiveMsgHandle;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ReceiveMsgListener
implements IMessageListener {
    private static final Logger log = LoggerFactory.getLogger(ReceiveMsgListener.class);
    private GlobalReceiveMsgHandle globalReceiveMsgHandle;

    public ReceiveMsgListener(GlobalReceiveMsgHandle globalReceiveMsgHandle) {
        this.globalReceiveMsgHandle = globalReceiveMsgHandle;
    }

    protected void onReceiveBefore() {
        MDC.put((String)"traceId", (String)(System.currentTimeMillis() + "" + ThreadLocalRandom.current().nextInt(0, 10000)));
    }

    protected void onReceiveAfter() {
        MDC.remove((String)"traceId");
    }

    public boolean onMessage(SealedMessage sealedMessage) {
        block6: {
            try {
                this.onReceiveBefore();
                if (sealedMessage == null || sealedMessage.getHeader() == null || sealedMessage.getPayload() == null) {
                    log.info("receive netty data, but the parameter is empty.  {}", (Object)JacksonUtil.getInstance().toJson((Object)sealedMessage));
                    break block6;
                }
                this.globalReceiveMsgHandle.onReceive(sealedMessage);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                log.error("onMessage error={}", (Object)sealedMessage, (Object)e);
            }
            finally {
                this.onReceiveAfter();
            }
        }
        return false;
    }
}

