/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.verify.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.constant.enums.InvoiceTypeEnum;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.verify.AnalysisXmlRequest;
import com.xforceplus.evat.common.domain.verify.AnalysisXmlResponse;
import com.xforceplus.evat.common.domain.verify.AnalysisXmlResult;
import com.xforceplus.evat.common.modules.verify.VerifyService;
import com.xforceplus.evat.common.modules.verify.XmlService;
import com.xforceplus.evat.common.utils.CommonUtils;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XmlServiceImpl
implements XmlService {
    private static final Logger log = LoggerFactory.getLogger(XmlServiceImpl.class);
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;
    @Autowired
    private VerifyService verifyService;

    @Override
    public JsonResult<AnalysisXmlResult> analysisXml(AnalysisXmlRequest analysisXmlRequest) {
        try {
            if (StringUtils.isBlank((CharSequence)analysisXmlRequest.getXmlEncode())) {
                return JsonResult.error("xmlEncode\u53c2\u6570\u5fc5\u586b\uff0c\u8bf7\u786e\u8ba4\u3002");
            }
            log.debug(">>>>>> XML\u6587\u4ef6\u89e3\u6790\u8bf7\u6c42\u62a5\u6587 = {}", (Object)analysisXmlRequest.getSerialNo());
            if (StringUtils.isBlank((CharSequence)this.janusConfig.getTenantId())) {
                log.warn("xforceplus.janus.tenantId \u6ca1\u6709\u914d\u7f6e");
                return JsonResult.error("xforceplus.janus.tenantId\u6ca1\u6709\u914d\u7f6e");
            }
            analysisXmlRequest.setTenantCode(this.janusConfig.getTenantCode());
            JanusRequest janusRequest = JanusRequest.builder().build();
            janusRequest.setAction(this.janusActionConfig.getVerificationXml());
            janusRequest.setData(analysisXmlRequest);
            janusRequest.setPayLoadId(analysisXmlRequest.getSerialNo());
            JsonResult<AnalysisXmlResult> jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            if (jsonResult.isFail()) {
                log.info("<=== XML\u6587\u4ef6\u89e3\u6790\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587= {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                jsonResult.setData(null);
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            AnalysisXmlResponse analysisXmlResponse = (AnalysisXmlResponse)JSON.parseObject((String)data, (TypeReference)new TypeReference<AnalysisXmlResponse>(){}, (Feature[])new Feature[0]);
            log.debug("<<<<<< analysis xml result = {}", (Object)JacksonUtil.getInstance().toJson((Object)analysisXmlResponse));
            if (!analysisXmlResponse.isOK()) {
                log.info("<=== XML\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0cmessage= {}", (Object)analysisXmlResponse.getMessage());
                return JsonResult.error(analysisXmlResponse.getCode(), analysisXmlResponse.getMessage());
            }
            jsonResult = JsonResult.ok(analysisXmlResponse.getMessage());
            AnalysisXmlResult analysisXmlResult = analysisXmlResponse.getResult();
            this.analysisXmlHandle(analysisXmlResult);
            jsonResult.setData(analysisXmlResult);
            return jsonResult;
        }
        catch (Exception e) {
            log.error("XML\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0cERR\uff1a", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    public void analysisXmlHandle(AnalysisXmlResult analysisXmlResult) {
        if (analysisXmlResult == null || analysisXmlResult.getInvoiceMain() == null) {
            return;
        }
        AnalysisXmlResult.InvoiceMainDTO invoiceMain = analysisXmlResult.getInvoiceMain();
        String resultCode = InvoiceTypeEnum.getResultCode(invoiceMain.getInvoiceType()).orElse("");
        invoiceMain.setInvoiceType(resultCode);
        List<AnalysisXmlResult.InvoiceDetailsDTO> invoiceDetails = analysisXmlResult.getInvoiceDetails();
        invoiceDetails.forEach(s -> CommonUtils.taxRateHandle(s.getTaxRate()).ifPresent(taxRate -> s.setTaxRate(taxRate.stripTrailingZeros().toPlainString())));
    }
}

