/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.constant.enums.ncp;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum NcpTypeEnum {
    SELF_NCP("1", "\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968"),
    BUY3_NCP("2", "\u4ece\u5c0f\u89c4\u6a21\u5904\u8d2d\u8fdb\u76843%\u519c\u4ea7\u54c1\u53d1\u7968");

    private String code;
    private String tip;

    private NcpTypeEnum(String code, String tip) {
        this.code = code;
        this.tip = tip;
    }

    public static Optional<String> getTipByCode(String code) {
        return Arrays.stream(NcpTypeEnum.values()).filter(s -> s.getCode().equalsIgnoreCase(code)).findFirst().map(NcpTypeEnum::getTip);
    }

    public static NcpTypeEnum getByCode(String code) {
        for (NcpTypeEnum typeEnum : NcpTypeEnum.values()) {
            if (!StringUtils.equals((CharSequence)typeEnum.getCode(), (CharSequence)code)) continue;
            return typeEnum;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getTip() {
        return this.tip;
    }
}

