/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.device.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.device.TaxNoDeviceStateQuery;
import com.xforceplus.evat.common.domain.device.TaxNoDeviceStateResponse;
import com.xforceplus.evat.common.modules.device.TaxNoDeviceService;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaxNoDeviceServiceImpl
implements TaxNoDeviceService {
    private static final Logger log = LoggerFactory.getLogger(TaxNoDeviceServiceImpl.class);
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;

    @Override
    public JsonResult<List<String>> TaxNoDeviceStateQuery(TaxNoDeviceStateQuery taxNoDeviceStateQuery) {
        log.debug(">>>>>> \u7a0e\u53f7\u8bbe\u5907\u67e5\u8be2 upload info = {}", (Object)JacksonUtil.getInstance().toJson((Object)taxNoDeviceStateQuery));
        try {
            if (ObjectUtils.isEmpty((Object)taxNoDeviceStateQuery)) {
                return JsonResult.error("\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a");
            }
            Map<String, Object> taxNoDeviceStateParams = this.queryConditionBean(taxNoDeviceStateQuery);
            String payLoadId = taxNoDeviceStateQuery.getSerialNo();
            if (StringUtils.isBlank((CharSequence)taxNoDeviceStateQuery.getSerialNo())) {
                payLoadId = "" + System.currentTimeMillis();
                if (CollectionUtils.isNotEmpty(taxNoDeviceStateQuery.getCompanyTaxNo())) {
                    payLoadId = taxNoDeviceStateQuery.getCompanyTaxNo().get(0);
                }
            }
            JanusRequest janusRequest = JanusRequest.builder().build();
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            heaserMap.put("version", this.janusConfig.getTenantCode());
            janusRequest.setPayLoadId(payLoadId);
            janusRequest.setAction(this.janusConfig.getHttp().getAction().getCompanyLoginStatusBatchAction());
            janusRequest.setData(JSONObject.toJSONString(taxNoDeviceStateParams));
            janusRequest.setHeader(heaserMap);
            janusRequest.setDataType("JSON");
            log.debug("<<<<<< YL20051-\u7a0e\u53f7\u767b\u5f55\u72b6\u6001\u67e5\u8be2(\u6279\u91cf) request = {}", (Object)JacksonUtil.getInstance().toJson((Object)janusRequest));
            JsonResult jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            log.debug("<<<<<< YL20051-\u7a0e\u53f7\u767b\u5f55\u72b6\u6001\u67e5\u8be2(\u6279\u91cf) result = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            if (jsonResult.isFail()) {
                log.info("<=== YL20051-\u7a0e\u53f7\u767b\u5f55\u72b6\u6001\u67e5\u8be2(\u6279\u91cf) \uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                jsonResult.setData(null);
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            TaxNoDeviceStateResponse confirmationSheetResponse = (TaxNoDeviceStateResponse)JSON.parseObject((String)data, TaxNoDeviceStateResponse.class);
            if (!confirmationSheetResponse.isOK() || ObjectUtils.isEmpty((Object)confirmationSheetResponse.getResult()) || CollectionUtils.isEmpty(confirmationSheetResponse.getResult().getData())) {
                return JsonResult.error("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7a0e\u53f7\u8bbe\u5907\u4fe1\u606f");
            }
            List<Map<String, String>> taxNoDeviceResult = confirmationSheetResponse.getResult().getData();
            List excludeTaxNo = taxNoDeviceResult.stream().map(item -> (String)item.get("companyTaxNo")).collect(Collectors.toList());
            jsonResult.setData(excludeTaxNo);
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u7a0e\u53f7\u8bbe\u5907\u67e5\u8be2 request error ", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    @Override
    public boolean TaxNoDeviceOnLine(String taxNo, String serialNo) {
        TaxNoDeviceStateQuery taxNoDeviceStateQuery = new TaxNoDeviceStateQuery();
        taxNoDeviceStateQuery.setCompanyTaxNo(Collections.singletonList(taxNo));
        taxNoDeviceStateQuery.setStatus(NumberUtils.INTEGER_ONE);
        taxNoDeviceStateQuery.setSerialNo(serialNo);
        JsonResult<List<String>> listJsonResult = this.TaxNoDeviceStateQuery(taxNoDeviceStateQuery);
        return !StringUtils.equals((CharSequence)NumberUtils.INTEGER_ONE.toString(), (CharSequence)listJsonResult.getCode()) || !Objects.isNull(listJsonResult.getData());
    }

    private Map<String, Object> queryConditionBean(TaxNoDeviceStateQuery taxNoDeviceStateQuery) {
        HashMap<String, Object> whereCondition;
        ArrayList conditions = new ArrayList();
        if (CollectionUtils.isNotEmpty(taxNoDeviceStateQuery.getCompanyTaxNo())) {
            whereCondition = new HashMap<String, Object>();
            whereCondition.put("field", "companyTaxNo");
            whereCondition.put("conditionOP", "in");
            whereCondition.put("values", taxNoDeviceStateQuery.getCompanyTaxNo());
            conditions.add(whereCondition);
        }
        if (StringUtils.isNotBlank((CharSequence)taxNoDeviceStateQuery.getCompanyName())) {
            whereCondition = new HashMap();
            whereCondition.put("field", "companyName");
            whereCondition.put("conditionOP", "like");
            whereCondition.put("value", taxNoDeviceStateQuery.getCompanyName());
            conditions.add(whereCondition);
        }
        if (taxNoDeviceStateQuery.getStatus() != null) {
            whereCondition = new HashMap();
            whereCondition.put("field", "status");
            whereCondition.put("conditionOP", "eq");
            whereCondition.put("value", taxNoDeviceStateQuery.getStatus());
            conditions.add(whereCondition);
        }
        HashMap<String, Object> taxNoDeviceStateParams = new HashMap<String, Object>();
        taxNoDeviceStateParams.put("conditions", conditions);
        return taxNoDeviceStateParams;
    }
}

