/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.tcp;

import com.alibaba.fastjson.JSON;
import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.client.utils.SealedMessageBuilder;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.constant.consist.SealedRecMessage;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.modules.tcp.IReceiveMsgServiceHandler;
import com.xforceplus.evat.common.modules.tcp.ReceiveMsgServiceHandlerFactory;
import com.xforceplus.evat.common.utils.XNettyClientUtils;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Component;

@Component
public class GlobalReceiveMsgHandle {
    private static final Logger log = LoggerFactory.getLogger(GlobalReceiveMsgHandle.class);
    @Autowired
    private XNettyClientUtils xNettyClientUtils;
    @Autowired
    private ReceiveMsgServiceHandlerFactory receiveMsgServiceHandlerFactory;
    @Autowired
    private JanusConfig janusConfig;
    private ConcurrentMap<String, IReceiveMsgServiceHandler> serviceHandlerMap = new ConcurrentHashMap<String, IReceiveMsgServiceHandler>();

    public void onReceive(SealedMessage sealedMessage) throws Exception {
        if (sealedMessage == null || sealedMessage.getHeader() == null || sealedMessage.getPayload() == null) {
            log.info("receive netty data, but the parameter is empty.");
            return;
        }
        log.info("receive netty data, data={}", (Object)JacksonUtil.getInstance().toJson((Object)sealedMessage));
        SealedRecMessage.Header header = new SealedRecMessage.Header();
        SealedRecMessage.Payload payload = new SealedRecMessage.Payload();
        BeanCopier headerBeanCopier = BeanCopier.create(SealedMessage.Header.class, SealedRecMessage.Header.class, (boolean)false);
        BeanCopier payloadBeanCopier = BeanCopier.create(SealedMessage.Payload.class, SealedRecMessage.Payload.class, (boolean)false);
        headerBeanCopier.copy((Object)sealedMessage.getHeader(), (Object)header, null);
        payloadBeanCopier.copy((Object)sealedMessage.getPayload(), (Object)payload, null);
        SealedRecMessage sealedRecMessage = new SealedRecMessage(header, payload);
        String requestName = header.getRequestName();
        Object obj = sealedMessage.getPayload().getObj();
        IReceiveMsgServiceHandler receiveMsgServiceHandler = (IReceiveMsgServiceHandler)this.serviceHandlerMap.get(requestName);
        if (receiveMsgServiceHandler == null) {
            receiveMsgServiceHandler = this.receiveMsgServiceHandlerFactory.getHandleBean(requestName);
        }
        if (StringUtils.isBlank((CharSequence)requestName) || receiveMsgServiceHandler == null || Objects.isNull(obj)) {
            log.info("receive [{}] netty data , but handle[{}] or data empty", (Object)requestName, (Object)receiveMsgServiceHandler);
            return;
        }
        JsonResult jsonResult = receiveMsgServiceHandler.process(sealedRecMessage);
        this.sendReceipt(sealedMessage, true, JSON.toJSONString((Object)jsonResult));
    }

    public boolean sendReceipt(SealedMessage sealedMessage, boolean isTrue, String result) {
        boolean bool = false;
        try {
            sealedMessage = SealedMessageBuilder.buildReceiptMessage((String)this.janusConfig.getTcp().getCustomerNo(), (SealedMessage)sealedMessage, (boolean)isTrue, (String)result);
            bool = MCFactory.getInstance().sendMessage(sealedMessage);
            log.info("\u56de\u6267\u53d1\u9001\u5b8c\u6210:{},{}", (Object)sealedMessage.getPayload(), (Object)bool);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bool;
    }
}

