/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.verify.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.GlobalConstants;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.constant.enums.InvoiceTypeEnum;
import com.xforceplus.evat.common.constant.enums.SystemOrigEnum;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.verify.InvoiceDetail;
import com.xforceplus.evat.common.domain.verify.InvoiceMain;
import com.xforceplus.evat.common.domain.verify.VerificationRequest;
import com.xforceplus.evat.common.domain.verify.VerificationResponse;
import com.xforceplus.evat.common.modules.verify.VerifyService;
import com.xforceplus.evat.common.utils.CommonUtils;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VerifyServiceImpl
implements VerifyService {
    private static final Logger log = LoggerFactory.getLogger(VerifyServiceImpl.class);
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;

    @Override
    public JsonResult invoiceVerify(VerificationRequest verificationRequest) {
        log.debug(">>>>>> invoice verify upload info = {}", (Object)JacksonUtil.getInstance().toJson((Object)verificationRequest));
        try {
            String data;
            VerificationResponse verificationBack;
            if (StringUtils.isBlank((CharSequence)this.janusConfig.getTenantId())) {
                log.warn("xforceplus.janus.tenantId \u6ca1\u6709\u914d\u7f6e");
                return JsonResult.error("xforceplus.janus.tenantId\u6ca1\u6709\u914d\u7f6e");
            }
            boolean noneMatchOrig = Arrays.stream(SystemOrigEnum.values()).noneMatch(s -> StringUtils.equalsIgnoreCase((CharSequence)s.getSystemOrig(), (CharSequence)verificationRequest.getSystemOrig()));
            if (noneMatchOrig) {
                return JsonResult.error("\u7cfb\u7edf\u6765\u6e90[systemOrig]\u5b57\u6bb5\u672a\u914d\u7f6e");
            }
            verificationRequest.setInfoLevel("1");
            verificationRequest.setCustomerNo(verificationRequest.getSystemOrig());
            verificationRequest.setTenantCode(this.janusConfig.getTenantCode());
            JanusRequest janusRequest = JanusRequest.builder().build();
            janusRequest.setPayLoadId(verificationRequest.getInvoiceNo());
            janusRequest.setAction(this.janusActionConfig.getVerification());
            janusRequest.setData(verificationRequest);
            JsonResult<String> jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            log.debug("<<<<<< invoice verify result = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            if (jsonResult.isFail()) {
                log.info("<=== \u9a8c\u771f\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            }
            if (!(verificationBack = (VerificationResponse)JSON.parseObject((String)(data = String.valueOf(jsonResult.getData())), (TypeReference)new TypeReference<VerificationResponse<String>>(){}, (Feature[])new Feature[0])).isOK()) {
                return JsonResult.error(verificationBack.getCode(), verificationBack.getMessage());
            }
            jsonResult = JsonResult.ok(verificationBack.getMessage());
            String taskId = (String)verificationBack.getResult();
            jsonResult.setData(taskId);
            return jsonResult;
        }
        catch (Exception e) {
            log.error("invoice verify request error ", (Throwable)e);
            return JsonResult.error("\u9a8c\u771f\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public JsonResult invoiceVerifySync(VerificationRequest verificationRequest) {
        log.debug(">>>>>> invoice verify upload info = {}", (Object)JacksonUtil.getInstance().toJson((Object)verificationRequest));
        try {
            if (StringUtils.isBlank((CharSequence)this.janusConfig.getTenantId())) {
                log.warn("xforceplus.janus.tenantId \u6ca1\u6709\u914d\u7f6e");
                return JsonResult.error("xforceplus.janus.tenantId\u6ca1\u6709\u914d\u7f6e");
            }
            if (StringUtils.isBlank((CharSequence)verificationRequest.getSystemOrig())) {
                return JsonResult.error("\u7cfb\u7edf\u6765\u6e90[systemOrig]\u5b57\u6bb5\u5fc5\u586b");
            }
            verificationRequest.setInfoLevel("2");
            verificationRequest.setCustomerNo(this.janusConfig.getTcp().getCustomerNo());
            verificationRequest.setTenantCode(this.janusConfig.getTenantCode());
            JanusRequest janusRequest = JanusRequest.builder().build();
            janusRequest.setPayLoadId(verificationRequest.getInvoiceNo());
            janusRequest.setAction(this.janusActionConfig.getVerification());
            janusRequest.setData(verificationRequest);
            JsonResult<VerificationResponse.VerificationResult> jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            log.debug("<<<<<< invoice verify result = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
            if (jsonResult.isFail()) {
                log.info("<=== \u9a8c\u771f\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587 = {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return jsonResult;
            }
            String data = String.valueOf(jsonResult.getData());
            VerificationResponse verificationBack = (VerificationResponse)JSON.parseObject((String)data, (TypeReference)new TypeReference<VerificationResponse<VerificationResponse.VerificationResult>>(){}, (Feature[])new Feature[0]);
            if (!verificationBack.isOK()) {
                return JsonResult.error(verificationBack.getCode(), verificationBack.getMessage());
            }
            jsonResult = JsonResult.ok(verificationBack.getMessage());
            VerificationResponse.VerificationResult verificationResult = (VerificationResponse.VerificationResult)verificationBack.getResult();
            this.invoiceVerifyHandle(verificationResult);
            jsonResult.setData(verificationResult);
            return jsonResult;
        }
        catch (Exception e) {
            log.error("invoice verify request error ", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    @Override
    public void invoiceVerifyHandle(VerificationResponse.VerificationResult verificationResult) {
        List<InvoiceDetail> invoiceDetails;
        if (verificationResult == null || verificationResult.getInvoiceMain() == null) {
            return;
        }
        InvoiceMain invoiceMain = verificationResult.getInvoiceMain();
        GlobalConstants.INVOICE_CODE_EXCLUDE_LIST.stream().filter(s -> s.equalsIgnoreCase(invoiceMain.getInvoiceCode())).findAny().ifPresent(s -> invoiceMain.setInvoiceCode(""));
        InvoiceTypeEnum.getResultCode(invoiceMain.getInvoiceType()).ifPresent(invoiceMain::setInvoiceType);
        if (!Arrays.asList(InvoiceTypeEnum.QP_INVOICE_GENERAL.getResultCode(), InvoiceTypeEnum.QT_INVOICE_GENERAL.getResultCode()).contains(invoiceMain.getInvoiceType()) && !(invoiceDetails = verificationResult.getInvoiceDetails()).isEmpty()) {
            invoiceDetails.forEach(s -> CommonUtils.taxRateHandle(s.getTaxRate()).ifPresent(taxRate -> s.setTaxRate(taxRate.stripTrailingZeros().toPlainString())));
            invoiceDetails.removeIf(s -> GlobalConstants.DETAILS_EXCLUDE_LIST.contains(s.getCargoName()));
        }
    }
}

