/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedisLockUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisLockUtils.class);
    @Autowired(required=false)
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Serializable> boolean tryLock(String key, Runnable runnable, int leaseTime, int waitTime) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("key not empty");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable not null");
        }
        if (leaseTime < -1) {
            throw new IllegalArgumentException("leaseTime>=-1");
        }
        if (waitTime < 1) {
            throw new IllegalArgumentException("waitTime >= 1");
        }
        String lockKey = "lockKey:" + key;
        RLock lock = this.redissonClient.getLock(lockKey);
        if (!lock.tryLock((long)waitTime, (long)leaseTime, TimeUnit.SECONDS)) {
            log.warn("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25 lockKey={}", (Object)lockKey);
            return false;
        }
        try {
            log.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f lockKey={}", (Object)lockKey);
            runnable.run();
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                    log.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501 lockKey={}", (Object)lockKey);
                } else {
                    log.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501 \u5f53\u524d\u7ebf\u7a0b\u4e0d\u6301\u6709\u9501 lockKey={}", (Object)lockKey);
                }
            }
            catch (Exception e) {
                log.error("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5931\u8d25 lockKey={}", (Object)lockKey, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T tryLock(String key, Callable<T> callable, int leaseTime, int waitTime) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("key not empty");
        }
        if (callable == null) {
            throw new IllegalArgumentException("runnable not null");
        }
        if (leaseTime < -1) {
            throw new IllegalArgumentException("leaseTime>=-1");
        }
        if (waitTime < 1) {
            throw new IllegalArgumentException("waitTime >= 1");
        }
        String lockKey = "lockKey:" + key;
        RLock lock = this.redissonClient.getLock(lockKey);
        if (!lock.tryLock((long)waitTime, (long)leaseTime, TimeUnit.SECONDS)) {
            log.warn("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25 lockKey={}", (Object)lockKey);
            return null;
        }
        try {
            log.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f lockKey={}", (Object)lockKey);
            T t = callable.call();
            return t;
        }
        finally {
            try {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                    log.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501 lockKey={}", (Object)lockKey);
                } else {
                    log.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501 \u5f53\u524d\u7ebf\u7a0b\u4e0d\u6301\u6709\u9501 lockKey={}", (Object)lockKey);
                }
            }
            catch (Exception e) {
                log.error("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5931\u8d25 lockKey={}", (Object)lockKey, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryLock(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("key not empty");
        }
        String lockKey = "lockKey:" + key;
        RLock lock = this.redissonClient.getLock(lockKey);
        if (!lock.tryLock(0L, -1L, TimeUnit.SECONDS)) {
            log.warn("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25 lockKey={}", (Object)lockKey);
            return false;
        }
        try {
            log.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f lockKey={}", (Object)lockKey);
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                    log.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501 lockKey={}", (Object)lockKey);
                } else {
                    log.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501 \u5f53\u524d\u7ebf\u7a0b\u4e0d\u6301\u6709\u9501 lockKey={}", (Object)lockKey);
                }
            }
            catch (Exception e) {
                log.error("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5931\u8d25 lockKey={}", (Object)lockKey, (Object)e);
            }
        }
    }
}

