/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.xforceplus.evat.common.alerter.Alerter;
import com.xforceplus.evat.common.constant.consist.FtpConfigProperties;
import com.xforceplus.evat.common.modules.ftp.FtpService;
import com.xforceplus.evat.common.utils.SpringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class SFTPHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SFTPHandler.class);
    private ChannelSftp sftp = null;
    private Session session = null;
    private Channel channel = null;
    private String localImageRootPath;
    private String remoteImageRootPath;
    private String remoteCostFileRootPath;

    private SFTPHandler(String remoteImageRootPath, String localImageRootPath) {
        this.remoteImageRootPath = remoteImageRootPath;
        this.localImageRootPath = localImageRootPath;
    }

    private SFTPHandler(String remoteCostFileRootPath) {
        this.remoteCostFileRootPath = remoteCostFileRootPath;
    }

    public static SFTPHandler getHandler(String remoteImageRootPath, String localImageRootPath) {
        return new SFTPHandler(remoteImageRootPath, localImageRootPath);
    }

    public static SFTPHandler getHandler(String remoteCostFileRootPath) {
        return new SFTPHandler(remoteCostFileRootPath);
    }

    public void openChannel(FtpConfigProperties ftpConfigProperties) {
        try {
            this.session = FtpService.getSession(ftpConfigProperties);
            if (this.session == null) {
                LOGGER.error("\u83b7\u53d6SFTP Session\u4e3a\u7a7a\u3002");
                return;
            }
            this.channel = this.session.openChannel("sftp");
            this.channel.connect();
            this.sftp = (ChannelSftp)this.channel;
        }
        catch (Exception e) {
            LOGGER.error("sftp\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            Alerter alerter1 = SpringUtils.getBean(Alerter.class);
            alerter1.alert("sftp\u64cd\u4f5c\u5f02\u5e38", e);
        }
    }

    public void closeChannel() {
        if (null != this.channel) {
            this.channel.disconnect();
        }
        if (null != this.session) {
            this.session.disconnect();
        }
        if (null != this.sftp) {
            this.sftp.disconnect();
        }
    }

    public List<String> getFileNameList(String keyName) throws JSchException, SftpException {
        ArrayList<String> fileNamelist = new ArrayList<String>();
        if (null == this.sftp || this.sftp.isClosed()) {
            throw new JSchException("\u94fe\u63a5\u4e22\u5931");
        }
        try {
            this.sftp.cd(this.remoteImageRootPath);
        }
        catch (SftpException e) {
            if (2 == e.id) {
                this.sftp.mkdir(this.remoteImageRootPath);
                this.sftp.cd(this.remoteImageRootPath);
            }
            throw e;
        }
        Vector vector = this.sftp.ls(keyName);
        for (ChannelSftp.LsEntry lsEntry : vector) {
            fileNamelist.add(lsEntry.getFilename());
        }
        return fileNamelist;
    }

    public List<String> getLocalFileNameList(final String keyName) throws FileNotFoundException {
        ArrayList<String> fileNamelist = new ArrayList<String>();
        File directory = new File(this.localImageRootPath);
        if (!directory.exists()) {
            if (!directory.mkdir()) {
                throw new FileNotFoundException();
            }
            if (!directory.canWrite() && !directory.setWritable(true)) {
                throw new FileNotFoundException();
            }
        }
        String[] fileNames = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(keyName);
            }
        });
        fileNamelist.addAll(Arrays.asList(fileNames));
        return fileNamelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String downloadPath, String fileName) throws SftpException {
        FileOutputStream out = null;
        try {
            String[] pathArry = downloadPath.split("/");
            StringBuffer filePath = new StringBuffer("/");
            for (int i = 0; i < pathArry.length - 1; ++i) {
                if (pathArry[i].equals("")) continue;
                filePath.append(pathArry[i] + "/");
                if (this.isDirExist(filePath.toString())) {
                    this.sftp.cd(filePath.toString());
                    continue;
                }
                this.sftp.mkdir(filePath.toString());
                this.sftp.cd(filePath.toString());
            }
            File directory = new File(this.localImageRootPath);
            if (!directory.exists()) {
                if (!directory.mkdirs()) {
                    throw new FileNotFoundException();
                }
                if (!directory.canWrite() && !directory.setWritable(true)) {
                    throw new FileNotFoundException();
                }
            }
            File file = new File(this.localImageRootPath + fileName);
            out = new FileOutputStream(file);
            this.sftp.get(downloadPath, (OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(File file, String uploadFile) throws SftpException, FileNotFoundException {
        try {
            this.sftp.cd(this.remoteImageRootPath);
        }
        catch (SftpException e) {
            if (2 == e.id) {
                this.sftp.mkdir(this.remoteImageRootPath);
                this.sftp.cd(this.remoteImageRootPath);
            }
            throw e;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.sftp.put((InputStream)in, uploadFile);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadImg(String gfTaxNo, String pathDate, String uploadFile) throws SftpException, FileNotFoundException {
        String path = null;
        try {
            path = this.remoteImageRootPath + gfTaxNo + "/" + pathDate + "/";
            this.sftp.cd(path);
        }
        catch (SftpException e) {
            if (2 == e.id) {
                try {
                    this.createDir(path, this.sftp);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            throw e;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(this.localImageRootPath + uploadFile));
            this.sftp.put((InputStream)in, uploadFile);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadScanImage(String pathDate, String uploadFile) throws SftpException, FileNotFoundException {
        String path = null;
        Date scanDate = new Date();
        String years = new SimpleDateFormat("yyyy").format(scanDate);
        String month = new SimpleDateFormat("MM").format(scanDate);
        String day = new SimpleDateFormat("dd").format(scanDate);
        path = this.remoteImageRootPath + years + "/" + month + "/" + day + "/";
        try {
            this.sftp.cd(path);
        }
        catch (SftpException e) {
            if (2 == e.id) {
                try {
                    this.createDir(path, this.sftp);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            throw e;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(this.localImageRootPath + uploadFile));
            this.sftp.put((InputStream)in, uploadFile);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return path;
    }

    public String getRemoteImageRootPath() {
        return this.remoteImageRootPath;
    }

    public void setRemoteImageRootPath(String remoteImageRootPath) {
        this.remoteImageRootPath = remoteImageRootPath;
    }

    public void deleteRemote(String deletePath) throws SftpException {
        String[] pathArry = deletePath.split("/");
        StringBuffer filePath = new StringBuffer("/");
        for (int i = 0; i < pathArry.length - 1; ++i) {
            if (pathArry[i].equals("")) continue;
            filePath.append(pathArry[i] + "/");
            if (this.isDirExist(filePath.toString())) {
                this.sftp.cd(filePath.toString());
                continue;
            }
            this.sftp.mkdir(filePath.toString());
            this.sftp.cd(filePath.toString());
        }
        this.sftp.rm(deletePath);
    }

    public String getLocalImageRootPath() {
        return this.localImageRootPath;
    }

    public void setLocalImageRootPath(String localImageRootPath) {
        this.localImageRootPath = localImageRootPath;
    }

    public boolean isDirExist(String directory) {
        boolean isDirExistFlag = false;
        try {
            SftpATTRS sftpATTRS = this.sftp.lstat(directory);
            isDirExistFlag = true;
            return sftpATTRS.isDir();
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().equals("no such file")) {
                isDirExistFlag = false;
            }
            return isDirExistFlag;
        }
    }

    public void createDir(String createpath, ChannelSftp sftp) throws Exception {
        try {
            if (this.isDirExist(createpath)) {
                this.sftp.cd(createpath);
            }
            String[] pathArry = createpath.split("/");
            StringBuffer filePath = new StringBuffer("/");
            for (String path : pathArry) {
                if (path.equals("")) continue;
                filePath.append(path + "/");
                if (this.isDirExist(filePath.toString())) {
                    sftp.cd(filePath.toString());
                    continue;
                }
                sftp.mkdir(filePath.toString());
                sftp.cd(filePath.toString());
            }
            this.sftp.cd(createpath);
        }
        catch (SftpException e) {
            throw new Exception("\u521b\u5efa\u8def\u5f84\u9519\u8bef\uff1a" + createpath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(MultipartFile file) throws SftpException, FileNotFoundException {
        try {
            this.sftp.cd(this.remoteCostFileRootPath);
        }
        catch (SftpException e) {
            if (2 == e.id) {
                this.sftp.mkdir(this.remoteCostFileRootPath);
                this.sftp.cd(this.remoteCostFileRootPath);
            }
            throw e;
        }
        String prefix = "" + new Date().getTime();
        String fileName = file.getOriginalFilename();
        String suffix = "";
        int index = fileName.indexOf(46);
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        FileInputStream in = null;
        try {
            in = (FileInputStream)file.getInputStream();
            this.sftp.put((InputStream)in, prefix + suffix);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.remoteCostFileRootPath + prefix + suffix;
    }

    public List<String> getFileNameList() throws JSchException, SftpException {
        ArrayList<String> fileNamelist = new ArrayList<String>();
        if (null == this.sftp || this.sftp.isClosed()) {
            throw new JSchException("\u94fe\u63a5\u4e22\u5931");
        }
        try {
            this.sftp.cd(this.remoteImageRootPath);
        }
        catch (SftpException e) {
            if (2 == e.id) {
                this.sftp.mkdir(this.remoteImageRootPath);
                this.sftp.cd(this.remoteImageRootPath);
            }
            throw e;
        }
        Vector vector = this.sftp.ls(this.remoteImageRootPath);
        for (ChannelSftp.LsEntry lsEntry : vector) {
            if (!lsEntry.getFilename().toLowerCase().endsWith(".csv") && !lsEntry.getFilename().toLowerCase().endsWith(".xlsx") && !lsEntry.getFilename().toLowerCase().endsWith(".xls")) continue;
            fileNamelist.add(lsEntry.getFilename());
        }
        return fileNamelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String move(String tempPath) throws SftpException, IOException, FileNotFoundException {
        int len;
        try {
            this.sftp.cd(this.remoteImageRootPath);
        }
        catch (SftpException e) {
            if (2 == e.id) {
                this.sftp.mkdir(this.remoteImageRootPath);
                this.sftp.cd(this.remoteImageRootPath);
            }
            throw e;
        }
        String fileName = tempPath.substring(tempPath.lastIndexOf(47) + 1);
        InputStream tInputStream = this.sftp.get(tempPath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = tInputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        InputStream nInputStream = null;
        try {
            nInputStream = new ByteArrayInputStream(baos.toByteArray());
            this.sftp.put(nInputStream, this.remoteImageRootPath + fileName);
        }
        finally {
            nInputStream.close();
            baos.close();
            tInputStream.close();
        }
        this.sftp.cd(this.localImageRootPath);
        this.sftp.rm(tempPath);
        return this.remoteImageRootPath + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onlyUploadImg(String gfTaxNo, String pathDate, String uploadFile) throws SftpException, FileNotFoundException {
        String path = null;
        try {
            path = this.remoteImageRootPath + gfTaxNo + "/" + pathDate + "/";
            this.sftp.cd(path);
        }
        catch (SftpException e) {
            if (2 == e.id) {
                try {
                    this.createDir(path, this.sftp);
                }
                catch (Exception e1) {
                    LOGGER.error(e.getMessage());
                }
            }
            throw e;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(this.localImageRootPath + uploadFile));
            this.sftp.put((InputStream)in, uploadFile);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return path;
    }
}

