/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import com.xforceplus.evat.common.exception.RRException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxRateUtils {
    private static final Logger log = LoggerFactory.getLogger(TaxRateUtils.class);
    private static final BigDecimal ONE = BigDecimal.valueOf(1L);
    private static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
    public static final List<String> taxRate9 = Arrays.asList("9", "9.0", "9.00", "0.09");

    public static String strTaxRateToStr(String taxRate) {
        if (StringUtils.isEmpty((CharSequence)taxRate)) {
            throw new RRException("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            BigDecimal bigTaxRate = new BigDecimal(taxRate);
            if (TaxRateUtils.isSmallTaxRate(bigTaxRate)) {
                return ONE_HUNDRED.multiply(bigTaxRate).toString();
            }
            return bigTaxRate.toString();
        }
        catch (NumberFormatException e) {
            log.error("\u5b57\u7b26\u4e32\u7a0e\u7387\u8f6cBigDecimal\u5931\u8d25:", (Throwable)e);
            return "0";
        }
    }

    public static String strTaxRateToStr(BigDecimal taxRate) {
        if (null == taxRate) {
            return "";
        }
        try {
            if (TaxRateUtils.isSmallTaxRate(taxRate)) {
                return ONE_HUNDRED.multiply(taxRate).setScale(0, 4).toString();
            }
            return taxRate.toString();
        }
        catch (NumberFormatException e) {
            log.error("\u5b57\u7b26\u4e32\u7a0e\u7387\u8f6cBigDecimal\u5931\u8d25:", (Throwable)e);
            return "0";
        }
    }

    public static String strTaxRateToSmallStr(String taxRate) {
        if (StringUtils.isEmpty((CharSequence)taxRate)) {
            throw new RRException("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            BigDecimal bigTaxRate = new BigDecimal(taxRate);
            if (TaxRateUtils.isSmallTaxRate(bigTaxRate)) {
                return bigTaxRate.toString();
            }
            return bigTaxRate.divide(ONE_HUNDRED).toString();
        }
        catch (NumberFormatException e) {
            log.error("\u5b57\u7b26\u4e32\u7a0e\u7387\u8f6cBigDecimal\u5931\u8d25:", (Throwable)e);
            return "0";
        }
    }

    public static String strTaxRateToSmallStr(BigDecimal taxRate) {
        if (null == taxRate) {
            return "";
        }
        try {
            if (TaxRateUtils.isSmallTaxRate(taxRate)) {
                return taxRate.toString();
            }
            return taxRate.divide(ONE_HUNDRED).setScale(0, 4).toString();
        }
        catch (NumberFormatException e) {
            log.error("\u5b57\u7b26\u4e32\u7a0e\u7387\u8f6cBigDecimal\u5931\u8d25:", (Throwable)e);
            return "0";
        }
    }

    public static boolean isSmallTaxRate(BigDecimal bigTaxRate) {
        return ONE.compareTo(bigTaxRate) > 0;
    }
}

