/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.constant.enums.ncp;

import com.xforceplus.evat.common.constant.enums.ncp.NcpTypeEnum;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum NcpHandleTypeEnum {
    NCP_HANDLE_TYPE_1("1", "\u5c5e\u4e8e\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968", NcpTypeEnum.SELF_NCP),
    NCP_HANDLE_TYPE_2("2", "\u4e0d\u5c5e\u4e8e\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968", NcpTypeEnum.SELF_NCP),
    NCP_HANDLE_TYPE_5("5", "\u90e8\u5206\u5c5e\u4e8e\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968", NcpTypeEnum.SELF_NCP),
    NCP_HANDLE_TYPE_3("3", "\u6309\u7968\u9762\u7a0e\u989d\u62b5\u6263", NcpTypeEnum.BUY3_NCP),
    NCP_HANDLE_TYPE_4("4", "\u6309\u7968\u9762\u91d1\u989d\u548c\u57fa\u7840\u6298\u6263\u8def\u8ba1\u7b97\u62b5\u6263", NcpTypeEnum.BUY3_NCP);

    private String code;
    private String tip;
    private NcpTypeEnum ncpTypeEnum;

    private NcpHandleTypeEnum(String code, String tip, NcpTypeEnum ncpTypeEnum) {
        this.code = code;
        this.tip = tip;
        this.ncpTypeEnum = ncpTypeEnum;
    }

    public static Optional<String> getTipByCode(String code) {
        return Arrays.stream(NcpHandleTypeEnum.values()).filter(s -> s.getCode().equalsIgnoreCase(code)).findFirst().map(NcpHandleTypeEnum::getTip);
    }

    public static Boolean check(String ncpTypeCode, String ncpHandleTypeCode) {
        for (NcpHandleTypeEnum handleTypeEnum : NcpHandleTypeEnum.values()) {
            if (!StringUtils.equals((CharSequence)handleTypeEnum.getCode(), (CharSequence)ncpHandleTypeCode) || !StringUtils.equals((CharSequence)handleTypeEnum.getNcpTypeEnum().getCode(), (CharSequence)ncpTypeCode)) continue;
            return true;
        }
        return false;
    }

    public static NcpHandleTypeEnum getByCode(String code) {
        for (NcpHandleTypeEnum handleTypeEnum : NcpHandleTypeEnum.values()) {
            if (!StringUtils.equals((CharSequence)handleTypeEnum.getCode(), (CharSequence)code)) continue;
            return handleTypeEnum;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getTip() {
        return this.tip;
    }

    public NcpTypeEnum getNcpTypeEnum() {
        return this.ncpTypeEnum;
    }
}

