/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.schedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.evat.common.constant.consist.CommonApiProperties;
import com.xforceplus.evat.common.utils.HttpClientUtils;
import com.xforceplus.evat.common.utils.SpringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ScheduledAspecj {
    private static final Logger log = LoggerFactory.getLogger(ScheduledAspecj.class);
    @Autowired
    private CommonApiProperties commonApiProperties;

    @Pointcut(value="@annotation(org.springframework.scheduling.annotation.Scheduled)")
    public void scheduled() {
    }

    @Around(value="scheduled()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        String dictdetaNo = SpringUtils.getAppName() + "_" + className + "_" + methodName;
        log.info("\u83b7\u53d6\u5230\u53ef\u80fd\u8981\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1\uff1a{}", (Object)dictdetaNo);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dictdetaNo", (Object)dictdetaNo);
        String result = null;
        try {
            result = HttpClientUtils.postJson(this.commonApiProperties.getBaseHost() + this.commonApiProperties.getQuerySchedulerOnOffConfig(), jsonObject.toJSONString());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        if (StringUtils.isEmpty(result)) {
            log.info("\u6ca1\u6709\u67e5\u5230\u5b9a\u65f6\u4efb\u52a1\u914d\u7f6e\u3010\u9ed8\u8ba4\u6267\u884c\u3011,\u4efb\u52a1ID:{}", (Object)dictdetaNo);
            return joinPoint.proceed();
        }
        JSONObject object = JSON.parseObject(result);
        Integer onOff = object.getInteger("onOff");
        if (NumberUtils.INTEGER_ONE == onOff) {
            log.info("\u5b9a\u65f6\u4efb\u52a1\u542f\u52a8\u72b6\u6001\u3010\u6b63\u5e38\u6267\u884c\u3011,\u4efb\u52a1ID:{}", (Object)dictdetaNo);
            return joinPoint.proceed();
        }
        log.info("\u5b9a\u65f6\u4efb\u52a1\u5173\u95ed\u72b6\u6001\u3010\u4e0d\u6267\u884c\u3011,\u4efb\u52a1ID:{}", (Object)dictdetaNo);
        return null;
    }
}

