/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.taxware.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.verify.OSSRequest;
import com.xforceplus.evat.common.modules.taxware.TaxWareOSSService;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import io.vavr.control.Either;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaxWareOSSServiceImpl
implements TaxWareOSSService {
    private static final Logger log = LoggerFactory.getLogger(TaxWareOSSServiceImpl.class);
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;

    @Override
    public Either<String, String> ossDownload(OSSRequest ossRequest) {
        try {
            log.debug(">>>>>> OSS\u4e0b\u8f7d\u8bf7\u6c42\u53c2\u6570 = {}", JSON.toJSON((Object)ossRequest));
            if (ossRequest == null || StringUtils.isBlank((CharSequence)ossRequest.getSerialNo())) {
                return Either.left((Object)"serialNo\u53c2\u6570\u5fc5\u586b\uff0c\u8bf7\u786e\u8ba4\u3002");
            }
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{ossRequest.getOssUrl(), ossRequest.getOssUrlLaws()})) {
                return Either.left((Object)"ossUrl/ossUrlLaws\u5747\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002");
            }
            if (StringUtils.isNotBlank((CharSequence)ossRequest.getOssUrl())) {
                ossRequest.setOssUrlLaws(new String(Base64.decodeBase64((String)ossRequest.getOssUrl())));
            }
            if (StringUtils.isNotBlank((CharSequence)ossRequest.getOssUrlLaws())) {
                ossRequest.setOssUrl(Base64.encodeBase64String((byte[])ossRequest.getOssUrlLaws().getBytes()));
            }
            Map paramMap = BeanUtils.describe((Object)ossRequest);
            JanusRequest janusRequest = JanusRequest.builder().action(this.janusActionConfig.getOssFileDownload()).params(paramMap).payLoadId(ossRequest.getSerialNo()).build();
            JsonResult jsonResult = this.okHttpClientUtils.sendGetMsg(janusRequest);
            if (jsonResult.isFail()) {
                log.info("<=== OSS\u4e0b\u8f7d\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587= {}", (Object)JacksonUtil.getInstance().toJson((Object)jsonResult));
                return Either.left((Object)jsonResult.getMessage());
            }
            String data = String.valueOf(jsonResult.getData());
            log.debug(">>>>>> OSS\u4e0b\u8f7d\u8bf7\u6c42\u6210\u529f\u3002");
            return Either.right((Object)data);
        }
        catch (Exception e) {
            log.error("error=", (Throwable)e);
            return Either.left((Object)"OSS\u4e0b\u8f7d\u5931\u8d25\u3002");
        }
    }
}

