/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.tcp;

import com.xforceplus.evat.common.constant.consist.XReceiveMsgType;
import com.xforceplus.evat.common.modules.tcp.IReceiveMsgServiceHandler;
import com.xforceplus.evat.common.modules.tcp.ReceiveMsgServiceHandlerFactory;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;

@Configuration
public class ReceiveMsgServiceHandlerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ReceiveMsgServiceHandlerConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={ReceiveMsgServiceHandlerFactory.class})
    public ReceiveMsgServiceHandlerFactory receiveMsgServiceHandlerFactory(List<IReceiveMsgServiceHandler> iReceiveMsgServiceHandler) {
        HashMap RECEIVE_MSG_HANDLE_MAP = new HashMap();
        iReceiveMsgServiceHandler.forEach(h -> {
            XReceiveMsgType xReceiveMsgType = (XReceiveMsgType)AnnotationUtils.findAnnotation(h.getClass(), XReceiveMsgType.class);
            if (xReceiveMsgType == null || StringUtils.isBlank((CharSequence)xReceiveMsgType.value())) {
                xReceiveMsgType = (XReceiveMsgType)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)AopProxyUtils.ultimateTargetClass((Object)h), XReceiveMsgType.class);
            }
            String value = xReceiveMsgType.value();
            log.info("init receiveMsgHandle , name={}, bean={}", (Object)value, (Object)xReceiveMsgType);
            RECEIVE_MSG_HANDLE_MAP.put(value, h);
        });
        return requestName -> {
            if (StringUtils.isBlank((CharSequence)requestName) || RECEIVE_MSG_HANDLE_MAP.size() < 1) {
                return null;
            }
            return (IReceiveMsgServiceHandler)RECEIVE_MSG_HANDLE_MAP.get(requestName);
        };
    }
}

