/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.constant.consist.SealedRecMessage;
import com.xforceplus.evat.common.domain.JsonResult;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XNettyClientUtils {
    private static final Logger log = LoggerFactory.getLogger(XNettyClientUtils.class);
    @Autowired
    private JanusConfig janusConfig;

    public void sendReceiptMsg(SealedRecMessage sealedRecMessage, JsonResult jsonResult) {
        if (StringUtils.isBlank((CharSequence)this.janusConfig.getTcp().getCustomerNo()) || jsonResult == null || sealedRecMessage == null || sealedRecMessage.getHeader() == null) {
            return;
        }
        try {
            SealedRecMessage.Header sealedRecMessageHeader = sealedRecMessage.getHeader();
            HashMap<String, String> others = new HashMap<String, String>(6);
            others.put("sourceMsgId", sealedRecMessageHeader.getMsgId());
            others.put("zt", jsonResult.isSuccess() + "");
            others.put("payLoadId", sealedRecMessageHeader.getMsgId());
            others.put("sourceRequestName", sealedRecMessageHeader.getRequestName());
            others.put("sourceUserId", sealedRecMessageHeader.getUserId());
            String strUsers = "[\"" + sealedRecMessageHeader.getUserId() + "\"]";
            others.put("others_destinations", strUsers);
            SealedMessage.Header header = new SealedMessage.Header(this.janusConfig.getTcp().getCustomerNo(), "request_receipt", others);
            SealedMessage.Payload payload = new SealedMessage.Payload((Object)jsonResult.getMessage());
            SealedMessage sealedMessage = new SealedMessage(header, payload);
            MCFactory.getInstance().sendMessage(sealedMessage);
            log.debug(" send [{}] receipt netty data , result:{}", (Object)sealedRecMessageHeader.getMsgId(), (Object)jsonResult.getMessage());
        }
        catch (Exception e) {
            log.error("send receipt netty data error={}", (Object)e.getMessage());
        }
    }
}

