/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.constant.enums;

import java.util.EnumSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum QsTypeEnum {
    SM("0", "\u626b\u7801\u7b7e\u6536", null),
    SMY("1", "\u626b\u63cf\u4eea\u7b7e\u6536", null),
    APP("2", "app\u7b7e\u6536", null),
    DR("3", "\u5bfc\u5165\u7b7e\u6536", null),
    SG("4", "\u624b\u5de5\u7b7e\u6536", null),
    PDF("5", "pdf\u7b7e\u6536", "pdf"),
    OFD("6", "ofd\u7b7e\u6536", "ofd"),
    XML("7", "xml\u7b7e\u6536", "xml");

    private String qsType;
    private String msgTipe;
    private String suffix;

    private QsTypeEnum(String qsType, String msgTipe, String suffix) {
        this.qsType = qsType;
        this.msgTipe = msgTipe;
        this.suffix = suffix;
    }

    public static String getQsTypeBySuffix(String suffix) {
        Optional<String> op = QsTypeEnum.electronicInvoicesQsType().stream().filter(qsTypeEnum -> StringUtils.equals((CharSequence)qsTypeEnum.suffix, (CharSequence)suffix.toLowerCase())).findFirst().map(QsTypeEnum::getQsType);
        return op.isPresent() ? op.get() : null;
    }

    public static QsTypeEnum getByQsType(String qsType) {
        for (QsTypeEnum qsTypeEnum : QsTypeEnum.values()) {
            if (!StringUtils.equalsAnyIgnoreCase((CharSequence)qsType, (CharSequence[])new CharSequence[]{qsTypeEnum.getQsType()})) continue;
            return qsTypeEnum;
        }
        return null;
    }

    private static EnumSet<QsTypeEnum> electronicInvoicesQsType() {
        return EnumSet.of(PDF, OFD, XML);
    }

    public String getQsType() {
        return this.qsType;
    }

    public String getMsgTipe() {
        return this.msgTipe;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

