/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.invoice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.evat.common.constant.consist.CommonApiProperties;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.file.FileStoreRequest;
import com.xforceplus.evat.common.domain.file.FileStoreResponse;
import com.xforceplus.evat.common.modules.invoice.InvoiceFileDownloadService;
import com.xforceplus.evat.common.utils.HttpClientUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceFileDownloadServiceImpl
implements InvoiceFileDownloadService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceFileDownloadServiceImpl.class);
    @Autowired
    private CommonApiProperties commonApiProperties;

    @Override
    public JsonResult<FileStoreResponse> download(Long id) {
        String url = this.commonApiProperties.getBaseHost() + this.commonApiProperties.getInvoiceDownloadUrl() + "/" + id;
        try {
            String result = HttpClientUtils.post(url, new HashMap<String, String>());
            JsonResult jsonResult = (JsonResult)JSON.parseObject((String)result, (TypeReference)new TypeReference<JsonResult<FileStoreResponse>>(){}, (Feature[])new Feature[0]);
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            return JsonResult.error("\u4e0b\u8f7d\u5931\u8d25");
        }
    }

    @Override
    public JsonResult uploadFile(FileStoreRequest request) {
        String result = HttpClientUtils.postJson(this.commonApiProperties.getBaseHost() + this.commonApiProperties.getUploadFileUrl(), JSON.toJSONString((Object)request));
        log.info("\u4e0a\u4f20\u5b8c\u6210:{}", (Object)result);
        JsonResult jsonResult = (JsonResult)JSON.parseObject((String)result, JsonResult.class);
        return jsonResult;
    }
}

