/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.modules.taxware.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.evat.common.constant.consist.JanusActionConfig;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.domain.JanusRequest;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.verify.TaxWareCheckRequest;
import com.xforceplus.evat.common.domain.verify.TaxWareCheckResponse;
import com.xforceplus.evat.common.domain.verify.TaxWareCheckResultResponse;
import com.xforceplus.evat.common.modules.taxware.TaxWareService;
import com.xforceplus.evat.common.utils.OkHttpClientUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaxWareServiceImpl
implements TaxWareService {
    private static final Logger log = LoggerFactory.getLogger(TaxWareServiceImpl.class);
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private JanusActionConfig janusActionConfig;
    @Autowired
    private OkHttpClientUtils okHttpClientUtils;

    @Override
    public JsonResult check(TaxWareCheckRequest taxWareCheckRequest) {
        log.info("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u8bf7\u6c42\u53c2\u6570:{}", JSON.toJSON((Object)taxWareCheckRequest));
        try {
            Tuple2<Boolean, String> checkRequest = this.checkRequest(taxWareCheckRequest);
            if (((Boolean)checkRequest._1()).booleanValue()) {
                return JsonResult.error((String)checkRequest._2());
            }
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            JanusRequest janusRequest = JanusRequest.builder().payLoadId(taxWareCheckRequest.getCustomsPaymentNo()).action(this.janusActionConfig.getTaxwareCheckAction()).tenantId(this.janusConfig.getTenantCode()).header(heaserMap).isValid(0).data(taxWareCheckRequest).build();
            JsonResult<TaxWareCheckResponse.TaxWareCheckResponseResult> jsonResult = this.okHttpClientUtils.sendMsg(janusRequest);
            log.info("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u8bf7\u6c42\uff0c\u8fd4\u56de\u62a5\u6587 = {}", JSON.toJSON((Object)jsonResult));
            String data = String.valueOf(jsonResult.getData());
            TaxWareCheckResponse taxWareCheckResponse = (TaxWareCheckResponse)JSON.parseObject((String)data, (TypeReference)new TypeReference<TaxWareCheckResponse>(){}, (Feature[])new Feature[0]);
            if (!taxWareCheckResponse.isOk()) {
                return JsonResult.error(taxWareCheckResponse.getCode() + "", taxWareCheckResponse.getMessage());
            }
            jsonResult = JsonResult.ok(taxWareCheckResponse.getMessage());
            jsonResult.setData(taxWareCheckResponse.getResult());
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u8bf7\u6c42\u5931\u8d25\uff0cERR\uff1a", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    @Override
    public JsonResult checkResult(String taskId) {
        log.info("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u7ed3\u679c\u8bf7\u6c42\u53c2\u6570:{}", (Object)taskId);
        try {
            if (StringUtils.isBlank((CharSequence)taskId)) {
                return JsonResult.error("taskId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashMap<String, String> heaserMap = new HashMap<String, String>();
            heaserMap.put("tenantCode", this.janusConfig.getTenantCode());
            heaserMap.put("taskId", taskId);
            JanusRequest janusRequest = JanusRequest.builder().payLoadId(taskId).action(this.janusActionConfig.getTaxwareCheckResultAction()).tenantId(this.janusConfig.getTenantCode()).header(heaserMap).isValid(0).data(taskId).build();
            JsonResult<TaxWareCheckResultResponse.TaxWareCheckResult> jsonResult = this.okHttpClientUtils.sendGetMsg(janusRequest);
            log.info("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u7ed3\u679c\u8bf7\u6c42\uff0c\u8fd4\u56de\u62a5\u6587 = {}", JSON.toJSON((Object)jsonResult));
            String data = String.valueOf(jsonResult.getData());
            TaxWareCheckResultResponse taxWareCheckResultResponse = (TaxWareCheckResultResponse)JSON.parseObject((String)data, (TypeReference)new TypeReference<TaxWareCheckResultResponse>(){}, (Feature[])new Feature[0]);
            if (!taxWareCheckResultResponse.isOk()) {
                return JsonResult.error(taxWareCheckResultResponse.getCode() + "", taxWareCheckResultResponse.getMessage());
            }
            jsonResult = JsonResult.ok(taxWareCheckResultResponse.getMessage());
            jsonResult.setData(taxWareCheckResultResponse.getResult());
            return jsonResult;
        }
        catch (Exception e) {
            log.error("\u6d77\u5173\u7f34\u6b3e\u4e66\u8ba4\u8bc1\u7ed3\u679c\u8bf7\u6c42\u5931\u8d25\uff0cERR\uff1a", (Throwable)e);
            return JsonResult.error(e.getMessage());
        }
    }

    public Tuple2<Boolean, String> checkRequest(TaxWareCheckRequest taxWareCheckRequest) {
        if (Objects.isNull(taxWareCheckRequest)) {
            return Tuple.of((Object)true, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)taxWareCheckRequest.getCustomsPaymentNo())) {
            return Tuple.of((Object)true, (Object)"\u8bf7\u6d77\u5173\u7f34\u6b3e\u4e66\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)taxWareCheckRequest.getTaxNo())) {
            return Tuple.of((Object)true, (Object)"\u6709\u6548\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)taxWareCheckRequest.getDateIssued())) {
            return Tuple.of((Object)true, (Object)"\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)taxWareCheckRequest.getTaxPeriod())) {
            return Tuple.of((Object)true, (Object)"\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)taxWareCheckRequest.getAuthUse())) {
            return Tuple.of((Object)true, (Object)"\u8ba4\u8bc1\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Tuple.of((Object)false, (Object)"");
    }
}

