/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import java.lang.management.ManagementFactory;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class TraceUtils {
    private static final Logger log = LoggerFactory.getLogger(TraceUtils.class);
    public static final String TRACE_ID = "traceId";
    public static final String PID = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];

    public static String genMdcTraceId() {
        return PID + "." + Long.toHexString(System.currentTimeMillis()) + "." + Long.toHexString(ThreadLocalRandom.current().nextInt(0, 10000));
    }

    public static String getMdcTraceId() {
        Optional<String> mdcTraceId = Optional.ofNullable(MDC.get((String)TRACE_ID));
        if (mdcTraceId.isPresent()) {
            return mdcTraceId.get();
        }
        return "";
    }

    public static boolean setTraceId() {
        return TraceUtils.setTraceId("");
    }

    public static boolean appendTraceId(String itemTraceId) {
        return TraceUtils.setTraceId(TraceUtils.getMdcTraceId() + "-" + itemTraceId);
    }

    public static boolean setTraceId(String traceId) {
        String mdcTraceId = StringUtils.isBlank((CharSequence)traceId) ? TraceUtils.genMdcTraceId() : traceId;
        MDC.put((String)TRACE_ID, (String)mdcTraceId);
        return true;
    }

    public static void clearTraceId() {
        MDC.clear();
    }
}

