/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.support.ICUBidiReorderer;
import com.openhtmltopdf.bidi.support.ICUBidiSplitter;
import com.openhtmltopdf.extend.FSCacheEx;
import com.openhtmltopdf.extend.FSDOMMutator;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.impl.FSDefaultCacheStore;
import com.openhtmltopdf.latexsupport.LaTeXDOMMutator;
import com.openhtmltopdf.mathmlsupport.MathMLDrawer;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.openhtmltopdf.svgsupport.BatikSVGDrawer;
import com.openhtmltopdf.util.XRLog;
import com.xforceplus.evat.common.HtmlToPdfRenderBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

/*
 * Exception performing whole class analysis ignored.
 */
public class HtmlToPdfRendererFactory
implements PooledObjectFactory<HtmlToPdfRenderBuilder> {
    private static final Logger log = LoggerFactory.getLogger(HtmlToPdfRendererFactory.class);
    private static HashMap<String, FSSupplier<InputStream>> fontFSSupplierCache = new HashMap();
    private static HtmlToPdfRendererFactory factory = new HtmlToPdfRendererFactory();
    private static GenericObjectPool<HtmlToPdfRenderBuilder> objectPool;
    private static int MinIdle;
    private static int MaxIdle;
    private static int MaxTotal;
    private static long SoftMinEvictableIdleTimeMillis;

    public static void init() {
        factory.fontCache();
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(MaxIdle);
        poolConfig.setMaxTotal(MaxTotal);
        poolConfig.setMinIdle(MinIdle);
        poolConfig.setSoftMinEvictableIdleTimeMillis(SoftMinEvictableIdleTimeMillis);
        log.debug("pool param:");
        log.debug("MaxIdle:" + MaxIdle);
        log.debug("MaxTotal:" + MaxTotal);
        log.debug("MinIdle:" + MinIdle);
        objectPool = new GenericObjectPool((PooledObjectFactory)factory, poolConfig);
    }

    public static HtmlToPdfRenderBuilder getPdfRendererBuilderInstance() {
        if (objectPool == null) {
            HtmlToPdfRendererFactory.init();
        }
        log.debug("pollActiveNum:" + objectPool.getNumActive());
        return (HtmlToPdfRenderBuilder)objectPool.borrowObject();
    }

    public static void returnPdfBoxRenderer(HtmlToPdfRenderBuilder openhtpdfRenderObject) {
        if (objectPool == null) {
            HtmlToPdfRendererFactory.init();
        }
        if (openhtpdfRenderObject != null && openhtpdfRenderObject.isActive()) {
            objectPool.returnObject((Object)openhtpdfRenderObject);
        }
    }

    private void fontCache() {
        ClassPathResource resource = new ClassPathResource("fonts/Kaiti.ttf");
        InputStream inputStream = resource.getInputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)os);
        fontFSSupplierCache.put("Kaiti", () -> {
            log.debug("read font PSName Requesting font");
            return new ByteArrayInputStream(os.toByteArray());
        });
        inputStream.close();
        os.flush();
        os.close();
        resource = new ClassPathResource("fonts/SimSun.ttf");
        InputStream is1 = resource.getInputStream();
        ByteArrayOutputStream os1 = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is1, (OutputStream)os1);
        fontFSSupplierCache.put("SimSun", () -> {
            log.debug("read font PSName Requesting font");
            return new ByteArrayInputStream(os1.toByteArray());
        });
        is1.close();
        os1.flush();
        os1.close();
    }

    public PooledObject<HtmlToPdfRenderBuilder> makeObject() {
        String i = UUID.randomUUID().toString();
        log.debug("make OpenhttptopdfRender object\uff1a" + i);
        FSDefaultCacheStore fsCacheEx = new FSDefaultCacheStore();
        HtmlToPdfRenderBuilder openhttptopdfRenderBuilder = new HtmlToPdfRenderBuilder();
        PdfRendererBuilder builder = new PdfRendererBuilder();
        builder.useUnicodeBidiSplitter((BidiSplitterFactory)new ICUBidiSplitter.ICUBidiSplitterFactory());
        builder.useUnicodeBidiReorderer((BidiReorderer)new ICUBidiReorderer());
        builder.defaultTextDirection(BaseRendererBuilder.TextDirection.LTR);
        builder.useSVGDrawer((SVGDrawer)new BatikSVGDrawer());
        builder.useMathMLDrawer((SVGDrawer)new MathMLDrawer());
        builder.addDOMMutator((FSDOMMutator)LaTeXDOMMutator.INSTANCE);
        builder.defaultTextDirection(BaseRendererBuilder.TextDirection.LTR);
        builder.useCacheStore(PdfRendererBuilder.CacheStore.PDF_FONT_METRICS, (FSCacheEx)fsCacheEx);
        fontFSSupplierCache.forEach((key, value) -> {
            PdfRendererBuilder cfr_ignored_0 = (PdfRendererBuilder)builder.useFont(value, key, Integer.valueOf(500), BaseRendererBuilder.FontStyle.NORMAL, true);
        });
        builder.useFastMode();
        XRLog.setLoggingEnabled((boolean)false);
        openhttptopdfRenderBuilder.setPdfRendererBuilder(builder);
        return new DefaultPooledObject((Object)openhttptopdfRenderBuilder);
    }

    public void destroyObject(PooledObject<HtmlToPdfRenderBuilder> pooledObject) {
        ((HtmlToPdfRenderBuilder)pooledObject.getObject()).setActive(false);
    }

    public boolean validateObject(PooledObject<HtmlToPdfRenderBuilder> pooledObject) {
        return ((HtmlToPdfRenderBuilder)pooledObject.getObject()).isActive();
    }

    public void activateObject(PooledObject<HtmlToPdfRenderBuilder> pooledObject) {
        ((HtmlToPdfRenderBuilder)pooledObject.getObject()).setActive(true);
    }

    public void passivateObject(PooledObject<HtmlToPdfRenderBuilder> pooledObject) {
    }

    static {
        MinIdle = 5;
        MaxIdle = 8;
        MaxTotal = 10;
        SoftMinEvictableIdleTimeMillis = 30000L;
    }
}

