/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.common.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisUtils {
    @Autowired
    private RedisTemplate redisTemplate;

    public boolean expire(String key, long time) {
        return this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
    }

    public long getTime(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public boolean persist(String key) {
        return this.redisTemplate.boundValueOps((Object)key).persist();
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public void set(String key, Object value, long time) {
        if (time > 0L) {
            this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
        } else {
            this.redisTemplate.opsForValue().set((Object)key, value);
        }
    }

    public void batchSet(Map<String, String> keyAndValue) {
        this.redisTemplate.opsForValue().multiSet(keyAndValue);
    }

    public void batchSetIfAbsent(Map<String, String> keyAndValue) {
        this.redisTemplate.opsForValue().multiSetIfAbsent(keyAndValue);
    }

    public Long increment(String key, long number) {
        return this.redisTemplate.opsForValue().increment((Object)key, number);
    }

    public Double increment(String key, double number) {
        return this.redisTemplate.opsForValue().increment((Object)key, number);
    }

    public void sSet(String key, String value) {
        this.redisTemplate.opsForSet().add((Object)key, new Object[]{value});
    }

    public Set<String> members(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public void randomMembers(String key, long count) {
        this.redisTemplate.opsForSet().randomMembers((Object)key, count);
    }

    public Object randomMember(String key) {
        return this.redisTemplate.opsForSet().randomMember((Object)key);
    }

    public Object pop(String key) {
        return this.redisTemplate.opsForSet().pop((Object)"setValue");
    }

    public long size(String key) {
        return this.redisTemplate.opsForSet().size((Object)key);
    }

    public boolean sHasKey(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    public boolean isMember(String key, Object obj) {
        return this.redisTemplate.opsForSet().isMember((Object)key, obj);
    }

    public boolean move(String key, String value, String destKey) {
        return this.redisTemplate.opsForSet().move((Object)key, (Object)value, (Object)destKey);
    }

    public void remove(String key, Object ... values) {
        this.redisTemplate.opsForSet().remove((Object)key, values);
    }

    public Set<String> difference(String key, String destKey) {
        return this.redisTemplate.opsForSet().difference((Object)key, (Object)destKey);
    }

    public void add(String key, Map<String, String> map) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    public Map<Object, Object> getHashEntries(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hashKey(String key, String hashKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
    }

    public String getMapString(String key, String key2) {
        return this.redisTemplate.opsForHash().get((Object)"map1", (Object)"key1").toString();
    }

    public Integer getMapInt(String key, String key2) {
        return (Integer)this.redisTemplate.opsForHash().get((Object)"map1", (Object)"key1");
    }

    public String popValue(String key) {
        return this.redisTemplate.opsForSet().pop((Object)key).toString();
    }

    public Long delete(String key, String ... hashKeys) {
        return this.redisTemplate.opsForHash().delete((Object)key, (Object[])hashKeys);
    }

    public Long increment(String key, String hashKey, long number) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)hashKey, number);
    }

    public Double increment(String key, String hashKey, Double number) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)hashKey, number.doubleValue());
    }

    public Set<Object> hashKeys(String key) {
        return this.redisTemplate.opsForHash().keys((Object)key);
    }

    public Long hashSize(String key) {
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    public void leftPush(String key, String value) {
        this.redisTemplate.opsForList().leftPush((Object)key, (Object)value);
    }

    public Object index(String key, long index) {
        return this.redisTemplate.opsForList().index((Object)"list", 1L);
    }

    public List<String> range(String key, long start, long end) {
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public void leftPush(String key, String pivot, String value) {
        Long aLong = this.redisTemplate.opsForList().leftPush((Object)key, (Object)pivot, (Object)value);
    }

    public void leftPushAll(String key, String ... values) {
        this.redisTemplate.opsForList().leftPushAll((Object)key, (Object[])values);
    }

    public void leftPushAll(String key, String value) {
        this.redisTemplate.opsForList().rightPush((Object)key, (Object)value);
    }

    public void rightPushAll(String key, String ... values) {
        this.redisTemplate.opsForList().rightPushAll((Object)key, (Object[])values);
    }

    public void rightPushIfPresent(String key, String value) {
        this.redisTemplate.opsForList().rightPushIfPresent((Object)key, (Object)value);
    }

    public long listLength(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    public void leftPop(String key) {
        this.redisTemplate.opsForList().leftPop((Object)key);
    }

    public void leftPop(String key, long timeout, TimeUnit unit) {
        this.redisTemplate.opsForList().leftPop((Object)key, timeout, unit);
    }

    public void rightPop(String key) {
        this.redisTemplate.opsForList().rightPop((Object)key);
    }

    public void rightPop(String key, long timeout, TimeUnit unit) {
        this.redisTemplate.opsForList().rightPop((Object)key, timeout, unit);
    }
}

