/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.configuration;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.xforceplus.evat.common.configuration.MyLocalDateDeserializer;
import com.xforceplus.evat.common.configuration.MyLocalDateTimeDeserializer;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
public class JacksonConfiguration {
    @Autowired
    private JacksonProperties jacksonProperties;

    @Bean(value={"javaTimeModule"})
    public JavaTimeModule javaTimeModule() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        String dateFormatPattern = this.jacksonProperties == null ? "yyyy-MM-dd HH:mm:ss" : (String)StringUtils.defaultIfBlank((CharSequence)this.jacksonProperties.getDateFormat(), (CharSequence)"yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormatPattern);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormatter));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(dateFormatter));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(timeFormatter));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new MyLocalDateTimeDeserializer(dateFormatPattern));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new MyLocalDateDeserializer("yyyy-MM-dd"));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(timeFormatter));
        return javaTimeModule;
    }

    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(ObjectMapper objectMapper) {
        objectMapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new /* Unavailable Anonymous Inner Class!! */);
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        mappingJackson2HttpMessageConverter.setObjectMapper(objectMapper);
        return mappingJackson2HttpMessageConverter;
    }

    @Bean
    public SimpleModule customSimpleModule() {
        SimpleModule customSimpleModule = new SimpleModule("CustomSimpleModule");
        customSimpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        customSimpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        customSimpleModule.addSerializer(Double.class, this.doubleSerializer());
        customSimpleModule.addSerializer(BigDecimal.class, this.bigDecimalSerializer());
        return customSimpleModule;
    }

    private JsonSerializer<Double> doubleSerializer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private JsonSerializer<BigDecimal> bigDecimalSerializer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

