/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.controller;

import com.alibaba.fastjson.JSON;
import com.xforceplus.evat.common.constant.enums.InvoiceFileTypeEnum;
import com.xforceplus.evat.common.domain.file.FileStoreResponse;
import com.xforceplus.evat.common.domain.file.FileViewRequest;
import com.xforceplus.evat.common.domain.file.FileViewResponse;
import com.xforceplus.evat.common.utils.CommonUtils;
import com.xforceplus.evat.modules.service.FileStoreService;
import io.vavr.control.Either;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/file/preview"})
public class FilePreviewController {
    private static final Logger log = LoggerFactory.getLogger(FilePreviewController.class);
    @Autowired
    private FileStoreService fileStoreService;

    @RequestMapping(value={"/{businessDataId}.html"})
    public String preview(Model model, @PathVariable(value="businessDataId") String businessDataId) {
        businessDataId = CommonUtils.strSecurityFilter((String)businessDataId);
        FileViewRequest fileViewRequest = FileViewRequest.builder().businessDataId(businessDataId).build();
        log.info("\u9884\u89c8\u53d1\u7968\u6e90\u6587\u4ef6:{}", (Object)businessDataId);
        Either either = this.fileStoreService.filePreview(fileViewRequest);
        if (either.isLeft()) {
            log.info("\u9884\u89c8\u53d1\u7968\u6e90\u6587\u4ef6\u5931\u8d25:{}", either.getLeft());
            model.addAttribute("message", either.getLeft());
            return "preview_pdf";
        }
        FileViewResponse fileViewResponse = (FileViewResponse)either.get();
        log.info("\u9884\u89c8\u53d1\u7968\u6e90\u6587\u4ef6={}", (Object)JSON.toJSONString((Object)fileViewResponse));
        model.addAttribute("data", (Object)fileViewResponse);
        if (InvoiceFileTypeEnum.TYPE_OF_XML.getSuffix().equals(fileViewResponse.getFileType())) {
            return "preview_xml";
        }
        if (InvoiceFileTypeEnum.TYPE_OF_PDF.getSuffix().equals(fileViewResponse.getFileType())) {
            return "preview_pdf";
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)InvoiceFileTypeEnum.TYPE_OF_JPG.getSuffix(), (CharSequence[])new CharSequence[]{InvoiceFileTypeEnum.TYPE_OF_JPEG.getSuffix()})) {
            return "preview_img";
        }
        return "preview_pdf";
    }

    @RequestMapping(value={"/download/{invoiceNoCode}"})
    public void downInvoiceSourceFile(HttpServletResponse response, @PathVariable(value="invoiceNoCode") String invoiceNoCode) throws Exception {
        invoiceNoCode = CommonUtils.strSecurityFilter((String)invoiceNoCode);
        log.info("download source file id:{}", (Object)invoiceNoCode);
        Either either = this.fileStoreService.downInvoiceSourceFile(invoiceNoCode);
        if (either.isLeft()) {
            response.setContentType("text/html; chartset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            PrintWriter printWriter = response.getWriter();
            printWriter.print((String)either.getLeft());
            return;
        }
        FileStoreResponse fileStoreResponse = (FileStoreResponse)either.get();
        response.reset();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", "attachment;filename=file_" + fileStoreResponse.getFileName());
        response.getOutputStream().write(Base64.decodeBase64((String)fileStoreResponse.getFileEncode()));
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    @RequestMapping(value={"/{businessDataId}.pdf"})
    public String pdfPreview(Model model, @PathVariable(value="businessDataId") String businessDataId) {
        String newBusinessDataId = CommonUtils.strSecurityFilter((String)businessDataId);
        FileViewRequest fileViewRequest = FileViewRequest.builder().businessDataId(newBusinessDataId).build();
        log.info("pdfPreview businessDataId:{}", (Object)newBusinessDataId);
        Either either = this.fileStoreService.pdfPreview(fileViewRequest);
        if (either.isLeft()) {
            model.addAttribute("message", either.getLeft());
            return "preview_pdf";
        }
        model.addAttribute("data", either.get());
        return "preview_pdf";
    }

    @RequestMapping(value={"/{businessDataId}.xml"})
    public String xmlPreview(Model model, @PathVariable(value="businessDataId") String businessDataId) {
        String newBusinessDataId = CommonUtils.strSecurityFilter((String)businessDataId);
        FileViewRequest fileViewRequest = FileViewRequest.builder().businessDataId(newBusinessDataId).build();
        Either either = this.fileStoreService.xmlPreview(fileViewRequest);
        if (either.isLeft()) {
            model.addAttribute("message", either.getLeft());
            return "preview_xml";
        }
        model.addAttribute("data", either.get());
        return "preview_xml";
    }
}

