/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.controller;

import com.alibaba.fastjson.JSON;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.pdfDiscern.DiscernRequest;
import com.xforceplus.evat.common.domain.pdfDiscern.DiscernResult;
import com.xforceplus.evat.common.domain.pdfDiscern.DiscernResultDetail;
import com.xforceplus.evat.common.domain.verify.VerificationRequest;
import com.xforceplus.evat.common.domain.verify.VerificationResponse;
import com.xforceplus.evat.common.modules.pdf.PdfDiscernService;
import com.xforceplus.evat.modules.service.FileStoreService;
import com.xforceplus.evat.modules.service.InvoiceVerifyService;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/janus/pdf"})
public class PdfDiscernController {
    private static final Logger log = LoggerFactory.getLogger(PdfDiscernController.class);
    @Autowired
    private PdfDiscernService pdfDiscernService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private InvoiceVerifyService invoiceVerifyService;

    @PostMapping
    public JsonResult pdfDiscern(@RequestBody DiscernRequest discernRequest) {
        try {
            JsonResult jsonResult = this.pdfDiscernService.pdfDiscern(discernRequest);
            return jsonResult;
        }
        catch (Exception e) {
            log.error("error=", (Throwable)e);
            return null;
        }
    }

    @PostMapping(value={"/sync"})
    public JsonResult pdfDiscernSync(@RequestBody DiscernRequest discernRequest) {
        JsonResult jsonResult = this.pdfDiscernService.pdfDiscernSync(discernRequest);
        return jsonResult;
    }

    @PostMapping(value={"/sync/verify"})
    public JsonResult pdfDiscernVerify(@RequestBody DiscernRequest discernRequest) {
        DiscernRequest newDiscernRequest = new DiscernRequest();
        BeanUtils.copyProperties((Object)discernRequest, (Object)newDiscernRequest);
        log.info("pdfDiscernQuery newDiscernRequest:{}", (Object)JSON.toJSONString((Object)newDiscernRequest));
        String fileEncode = Optional.ofNullable(newDiscernRequest).map(DiscernRequest::getFile).orElse("");
        JsonResult jsonResult = this.pdfDiscernService.pdfDiscernSync(newDiscernRequest);
        if (jsonResult.isFail()) {
            jsonResult.setMessage("\u53d1\u8d77\u8bc6\u522b\u9519\u8bef\uff1a" + jsonResult.getMessage());
            return jsonResult;
        }
        DiscernResult discernResult = (DiscernResult)jsonResult.getData();
        Integer discernStatus = discernResult.getDiscernStatus();
        if (!discernStatus.equals(DiscernResult.CODE_SUCCESS)) {
            return JsonResult.error((String)"\u8bc6\u522b\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u8bc6\u522b\u7ed3\u679c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)discernResult.getDocumentType(), (CharSequence[])new CharSequence[]{"90009999", "90009998", "90001008", "90001009"})) {
            return JsonResult.error((String)"\u8bc6\u522b\u5931\u8d25\uff1a\u975e\u53d1\u7968\u7c7b\u578b\u6587\u4ef6\u3002");
        }
        DiscernResultDetail discernResultDetail = (DiscernResultDetail)JSON.parseObject((String)discernResult.getDiscernResult(), DiscernResultDetail.class);
        VerificationRequest verificationRequest = new VerificationRequest();
        verificationRequest.setInvoiceNo(discernResultDetail.getInvoiceNo());
        verificationRequest.setInvoiceCode(discernResultDetail.getInvoiceCode());
        verificationRequest.setPaperDrewDate(discernResultDetail.getInvoiceTime());
        verificationRequest.setCheckCode(discernResultDetail.getCheckCode());
        verificationRequest.setAmount(null == discernResultDetail.getTotalAmount() ? "" : discernResultDetail.getTotalAmount().toPlainString());
        verificationRequest.setAmountWithTax(null == discernResultDetail.getTotalAmountTaxNum() ? "" : discernResultDetail.getTotalAmountTaxNum().toPlainString());
        verificationRequest.setSystemOrig(newDiscernRequest.getSystemOrig());
        JsonResult verifyJsonResult = this.invoiceVerifyService.invoiceVerifySync(verificationRequest);
        if (verifyJsonResult.isFail()) {
            return verifyJsonResult;
        }
        VerificationResponse.VerificationResult verificationResult = (VerificationResponse.VerificationResult)verifyJsonResult.getData();
        newDiscernRequest.setFile(fileEncode);
        this.fileStoreService.pdfDiscernStore(verificationResult, newDiscernRequest);
        return verifyJsonResult;
    }

    @PostMapping(value={"/query"})
    public JsonResult pdfDiscernQuery(@RequestBody DiscernRequest discernRequest) {
        DiscernRequest newDiscernRequest = new DiscernRequest();
        BeanUtils.copyProperties((Object)discernRequest, (Object)newDiscernRequest);
        log.info("pdfDiscernQuery newDiscernRequest:{}", (Object)JSON.toJSONString((Object)newDiscernRequest));
        try {
            if (newDiscernRequest == null || StringUtils.isBlank((CharSequence)newDiscernRequest.getTaskIds())) {
                return JsonResult.error((String)"taskIds\u5fc5\u586b\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
            }
            JsonResult jsonResult = this.pdfDiscernService.pdfDiscernQuery(newDiscernRequest.getTaskIds());
            return jsonResult;
        }
        catch (Exception e) {
            log.error("error=", (Throwable)e);
            return null;
        }
    }

    @PostMapping(value={"/query/sync"})
    public JsonResult pdfDiscernQuerySync(@RequestBody DiscernRequest discernRequest) {
        DiscernRequest newDiscernRequest = new DiscernRequest();
        BeanUtils.copyProperties((Object)discernRequest, (Object)newDiscernRequest);
        log.info("pdfDiscernQuerySync newDiscernRequest:{}", (Object)JSON.toJSONString((Object)newDiscernRequest));
        if (newDiscernRequest == null || StringUtils.isBlank((CharSequence)newDiscernRequest.getTaskIds())) {
            return JsonResult.error((String)"taskIds\u5fc5\u586b\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
        }
        JsonResult jsonResult = this.pdfDiscernService.pdfDiscernQuerySync(newDiscernRequest.getTaskIds());
        return jsonResult;
    }
}

