/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.service.impl;

import cn.hutool.core.codec.Base64Decoder;
import cn.hutool.core.codec.Base64Encoder;
import com.alibaba.fastjson.JSON;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.xforceplus.evat.common.HtmlToPdfRenderBuilder;
import com.xforceplus.evat.common.HtmlToPdfRendererFactory;
import com.xforceplus.evat.common.constant.consist.FileStoreProperties;
import com.xforceplus.evat.common.constant.enums.BusinessTypeEnum;
import com.xforceplus.evat.common.constant.enums.InvoiceFileTypeEnum;
import com.xforceplus.evat.common.constant.enums.XfFileType;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.file.FileStoreRequest;
import com.xforceplus.evat.common.domain.file.FileStoreResponse;
import com.xforceplus.evat.common.domain.file.FileViewRequest;
import com.xforceplus.evat.common.domain.file.FileViewResponse;
import com.xforceplus.evat.common.domain.pdfDiscern.DiscernRequest;
import com.xforceplus.evat.common.domain.verify.AnalysisOfdRequest;
import com.xforceplus.evat.common.domain.verify.AnalysisOfdResponse;
import com.xforceplus.evat.common.domain.verify.AnalysisXmlRequest;
import com.xforceplus.evat.common.domain.verify.InvoiceMain;
import com.xforceplus.evat.common.domain.verify.VerificationResponse;
import com.xforceplus.evat.common.modules.ftp.FtpService;
import com.xforceplus.evat.common.utils.CommonUtils;
import com.xforceplus.evat.domain.TDxRecordInvoiceDetailEntity;
import com.xforceplus.evat.domain.TDxRecordInvoiceEntity;
import com.xforceplus.evat.domain.TXfInvoiceFileEntity;
import com.xforceplus.evat.modules.service.FileStoreService;
import com.xforceplus.evat.modules.service.TDxRecordInvoiceDetailService;
import com.xforceplus.evat.modules.service.TDxRecordInvoiceService;
import com.xforceplus.evat.modules.service.TXfInvoiceFileService;
import io.vavr.control.Either;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Service
public class FileStoreServiceImpl
implements FileStoreService {
    private static final Logger log = LoggerFactory.getLogger(FileStoreServiceImpl.class);
    @Autowired
    private FtpService ftpService;
    @Autowired
    private TXfInvoiceFileService tXfInvoiceFileService;
    @Autowired
    private TDxRecordInvoiceService tDxRecordInvoiceService;
    @Autowired
    private TDxRecordInvoiceDetailService tDxRecordInvoiceDetailService;
    @Autowired
    private FileStoreProperties fileStoreProperties;
    @Autowired
    private TemplateEngine templateEngine;

    public Either<String, FileStoreResponse> upload(FileStoreRequest fileStoreRequest) {
        return this.uploadFile(fileStoreRequest.getFileEncode(), fileStoreRequest.getFilePath(), fileStoreRequest.getFileName(), this.fileStoreProperties.getFileDefalutMehtod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Either<String, FileStoreResponse> uploadFile(String fileEncode, String filePath, String fileName, String storeMethod) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{fileEncode, storeMethod, filePath, fileName})) {
            return Either.left((Object)"\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
        }
        InputStream inputStream = null;
        try {
            byte[] fileContent = Base64Decoder.decode((CharSequence)fileEncode);
            if ("NAS".equalsIgnoreCase(storeMethod)) {
                File file = new File(filePath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                File uploadFile = new File(file, fileName);
                FileUtils.writeByteArrayToFile((File)uploadFile, (byte[])fileContent);
                Either either = Either.right((Object)FileStoreResponse.builder().storeMethod("NAS").filePath(uploadFile.getAbsolutePath()).build());
                return either;
            }
            if ("FTP".equalsIgnoreCase(storeMethod)) {
                inputStream = new ByteArrayInputStream(fileContent);
                String result = this.ftpService.uploadFile(filePath, fileName, inputStream);
                Either uploadFile = Either.right((Object)FileStoreResponse.builder().storeMethod("FTP").filePath(result).build());
                return uploadFile;
            }
            Either either = Either.left((Object)"\u6682\u65f6\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u65b9\u5f0f");
            return either;
        }
        catch (Exception e) {
            log.error("File Store Fail,Error=", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("File Store close stream,Error=", (Throwable)e);
                }
            }
        }
        return Either.left((Object)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonResult<FileStoreResponse> upload_V2(FileStoreRequest fileStoreRequest) {
        log.info("upload_V2 param: {}", (Object)JSON.toJSONString((Object)fileStoreRequest));
        if (fileStoreRequest == null) {
            return JsonResult.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)fileStoreRequest.getBusinessId())) {
            return JsonResult.error((String)"businessId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (XfFileType.getFileType((String)fileStoreRequest.getFileType()) == null) {
            return JsonResult.error((String)"fileType\u53c2\u6570\u9519\u8bef");
        }
        if (fileStoreRequest.getBusinessType() != null && BusinessTypeEnum.getBusinessType((String)fileStoreRequest.getBusinessType()) == null) {
            return JsonResult.error((String)"businessType\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)fileStoreRequest.getFileName())) {
            return JsonResult.error((String)"fileName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileStoreRequest.getFileType(), (CharSequence[])new CharSequence[]{XfFileType.INVOICE.getFileType()})) {
            if (StringUtils.isBlank((CharSequence)fileStoreRequest.getVenderId())) {
                return JsonResult.error((String)"\u53d1\u7968\u7c7b\u578b\uff0c\u4f9b\u5e94\u55466D\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)fileStoreRequest.getInvoiceCode()) && StringUtils.isNotBlank((CharSequence)fileStoreRequest.getInvoiceNo()) && fileStoreRequest.getInvoiceNo().length() != 20) {
                return JsonResult.error((String)"\u53d1\u7968\u7c7b\u578b\uff0c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)fileStoreRequest.getInvoiceNo())) {
                return JsonResult.error((String)"\u53d1\u7968\u7c7b\u578b\uff0c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)fileStoreRequest.getPaperDrewDate())) {
                return JsonResult.error((String)"\u53d1\u7968\u7c7b\u578b\uff0c\u53d1\u7968\u5f00\u5177\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            if (StringUtils.isBlank((CharSequence)fileStoreRequest.getInvoiceCode())) {
                fileStoreRequest.setInvoiceCode("");
            }
            if (StringUtils.isBlank((CharSequence)fileStoreRequest.getInvoiceNo())) {
                fileStoreRequest.setInvoiceNo("");
            }
            if (StringUtils.isBlank((CharSequence)fileStoreRequest.getPaperDrewDate())) {
                fileStoreRequest.setPaperDrewDate("");
            }
            if (StringUtils.isBlank((CharSequence)fileStoreRequest.getVenderId())) {
                fileStoreRequest.setVenderId("");
            }
        }
        String fileSuffix = FilenameUtils.getExtension((String)fileStoreRequest.getFileName());
        TXfInvoiceFileEntity invoiceFileEntity = this.tXfInvoiceFileService.queryByInvoiceCodeAndNo(fileStoreRequest.getInvoiceCode(), fileStoreRequest.getInvoiceNo(), fileSuffix);
        if (invoiceFileEntity != null) {
            String fileEncode = fileStoreRequest.getFileEncode();
            Either uploadResult = null;
            String filePath = invoiceFileEntity.getPath();
            if (StringUtils.isBlank((CharSequence)fileEncode)) {
                fileEncode = this.downFile(filePath, invoiceFileEntity.getStorage() + "");
            }
            String newFilePath = this.getFilePath(fileStoreRequest, fileSuffix);
            String newFileName = CommonUtils.genUUID() + "." + fileSuffix;
            try {
                uploadResult = this.uploadFile(fileEncode, newFilePath, newFileName, this.fileStoreProperties.getFileDefalutMehtod());
                if (uploadResult.isLeft()) {
                    JsonResult jsonResult = JsonResult.error((String)((String)uploadResult.getLeft()));
                    return jsonResult;
                }
                fileStoreRequest.setExt1(StringUtils.defaultString((String)fileStoreRequest.getExt1(), (String)invoiceFileEntity.getExt1()));
                BeanUtils.copyProperties((Object)fileStoreRequest, (Object)invoiceFileEntity);
                invoiceFileEntity.setPath(newFilePath + newFileName);
                invoiceFileEntity.setFileSuffix(fileSuffix);
                invoiceFileEntity.setStorage(Integer.valueOf(StringUtils.equalsAnyIgnoreCase((CharSequence)this.fileStoreProperties.getFileDefalutMehtod(), (CharSequence[])new CharSequence[]{"NAS"}) ? 0 : 1));
                int result = this.tXfInvoiceFileService.updateById(invoiceFileEntity);
                if (result > 0) {
                    this.removeFile(filePath, invoiceFileEntity.getStorage() + "");
                }
                if (fileStoreRequest.isGenPreviewFile()) {
                    Either either = this.genPreviewFile(fileStoreRequest, invoiceFileEntity);
                }
            }
            catch (Exception e) {
                log.error("upload_V2 save fail ", (Throwable)e);
                uploadResult = Either.left((Object)"\u53d1\u7968\u66f4\u65b0\u5931\u8d25");
            }
            finally {
                if (uploadResult.isLeft()) {
                    this.removeFile(newFilePath + newFileName, this.fileStoreProperties.getFileDefalutMehtod());
                }
            }
            return JsonResult.data((Object)uploadResult.get());
        }
        if (StringUtils.isBlank((CharSequence)fileStoreRequest.getFileEncode())) {
            return JsonResult.error((String)"fileEncode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String filePath = this.getFilePath(fileStoreRequest, fileSuffix);
        String fileName = UUID.randomUUID().toString().replace("-", "") + "." + fileSuffix;
        Either uploadResult = null;
        try {
            uploadResult = this.uploadFile(fileStoreRequest.getFileEncode(), filePath, fileName, this.fileStoreProperties.getFileDefalutMehtod());
            if (uploadResult.isLeft()) {
                JsonResult newFilePath = JsonResult.error((String)((String)uploadResult.getLeft()));
                return newFilePath;
            }
            TXfInvoiceFileEntity fileEntity = new TXfInvoiceFileEntity();
            BeanUtils.copyProperties((Object)fileStoreRequest, (Object)fileEntity);
            fileEntity.setPath(filePath + fileName);
            fileEntity.setFileSuffix(fileSuffix);
            fileEntity.setStorage(Integer.valueOf(StringUtils.equalsAnyIgnoreCase((CharSequence)this.fileStoreProperties.getFileDefalutMehtod(), (CharSequence[])new CharSequence[]{"NAS"}) ? 0 : 1));
            this.tXfInvoiceFileService.save(fileEntity);
            if (fileStoreRequest.isGenPreviewFile()) {
                Either either = this.genPreviewFile(fileStoreRequest, invoiceFileEntity);
            }
        }
        catch (Exception e) {
            log.error("upload_V2 save fail ", (Throwable)e);
            uploadResult = Either.left((Object)"\u53d1\u7968\u4fdd\u5b58\u5931\u8d25");
        }
        finally {
            if (uploadResult.isLeft()) {
                this.removeFile(filePath + fileName, this.fileStoreProperties.getFileDefalutMehtod());
            }
        }
        if (uploadResult.isLeft()) {
            return JsonResult.error((String)((String)uploadResult.getLeft()));
        }
        return JsonResult.data((Object)uploadResult.get());
    }

    private Either<String, String> genPreviewFile(FileStoreRequest fileStoreRequest, TXfInvoiceFileEntity invoiceFileEntity) {
        if (fileStoreRequest == null || !fileStoreRequest.isGenPreviewFile() || invoiceFileEntity == null) {
            log.info("\u6587\u4ef6\u50a8\u5b58\u4e3a\u7a7a\u6216\u4e0d\u751f\u6210\u9884\u89c8\u6587\u4ef6\u3002");
            return Either.left((Object)"\u6587\u4ef6\u50a8\u5b58\u4e3a\u7a7a\u6216\u4e0d\u751f\u6210\u9884\u89c8\u6587\u4ef6\u3002");
        }
        boolean supportFileSuffix = Stream.of(InvoiceFileTypeEnum.TYPE_OF_XML, InvoiceFileTypeEnum.TYPE_OF_OFD).map(InvoiceFileTypeEnum::getSuffix).anyMatch(invoiceFileEntity.getFileSuffix()::equalsIgnoreCase);
        if (!XfFileType.INVOICE.getFileType().equals(invoiceFileEntity.getFileType()) || !supportFileSuffix) {
            log.info("\u975e\u53d1\u7968\u6587\u4ef6\u6216\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\u3002fileType={},fileSuffix={}", (Object)invoiceFileEntity.getFileType(), (Object)invoiceFileEntity.getFileSuffix());
            return Either.left((Object)"\u975e\u53d1\u7968\u6587\u4ef6\u6216\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\u3002");
        }
        String invoiceCodeNo = invoiceFileEntity.getInvoiceCode() + invoiceFileEntity.getInvoiceNo();
        TXfInvoiceFileEntity tXfInvoiceFileEntity = new TXfInvoiceFileEntity();
        tXfInvoiceFileEntity.setInvoiceNoCode(invoiceCodeNo);
        List list = this.tXfInvoiceFileService.findList(tXfInvoiceFileEntity);
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("\u672a\u67e5\u8be2\u5230\u53d1\u7968\u6e90\u6587\u4ef6\u4fe1\u606f\u3002");
            return Either.left((Object)"\u672a\u67e5\u8be2\u5230\u53d1\u7968\u6e90\u6587\u4ef6\u4fe1\u606f\u3002");
        }
        Optional<TXfInvoiceFileEntity> pdfOptional = list.stream().filter(s -> InvoiceFileTypeEnum.TYPE_OF_PDF.getSuffix().equals(s.getFileSuffix())).findFirst();
        Optional<TXfInvoiceFileEntity> imgOptional = list.stream().filter(s -> StringUtils.equalsAny((CharSequence)s.getFileSuffix(), (CharSequence[])new CharSequence[]{InvoiceFileTypeEnum.TYPE_OF_JPG.getSuffix(), InvoiceFileTypeEnum.TYPE_OF_JPEG.getSuffix()})).findFirst();
        if (InvoiceFileTypeEnum.TYPE_OF_XML.getSuffix().equalsIgnoreCase(invoiceFileEntity.getFileSuffix())) {
            log.info("XML\u8f6c\u6362PDF\u9884\u89c8\u6587\u4ef6...");
            if (pdfOptional.isPresent()) {
                log.info("\u5df2\u6709PDF\u6587\u4ef6\uff0c\u4e0d\u8fdb\u884c\u8f6c\u6362\u3002");
                return Either.left((Object)"\u5df2\u6709PDF\u6587\u4ef6\uff0c\u4e0d\u8fdb\u884c\u8f6c\u6362\u3002");
            }
            try {
                FileViewRequest fileViewRequest = FileViewRequest.builder().businessDataId(invoiceCodeNo).build();
                Either xmlDataEither = this.xmlPreview(fileViewRequest);
                if (xmlDataEither.isLeft()) {
                    log.info("XML\u8f6c\u6362PDF\u5931\u8d25,\u672a\u83b7\u53d6\u5230\u5e95\u8d26\u4e1a\u52a1\u6570\u636e\u3002");
                    return Either.left((Object)"XML\u8f6c\u6362PDF\u5931\u8d25,\u672a\u83b7\u53d6\u5230\u5e95\u8d26\u4e1a\u52a1\u6570\u636e\u3002");
                }
                Context context = new Context();
                context.setVariable("data", xmlDataEither.get());
                String content = this.templateEngine.process("preview_xml", (IContext)context);
                ByteArrayOutputStream byteArrayOutputStream = this.genHtml2Pdf(content);
                String fileEncode = Base64.encodeBase64String((byte[])byteArrayOutputStream.toByteArray());
                fileStoreRequest.setFileEncode(fileEncode);
                fileStoreRequest.setFileName(invoiceCodeNo + ".pdf");
                fileStoreRequest.setGenPreviewFile(false);
                JsonResult jsonResult = this.upload_V2(fileStoreRequest);
                log.info("XML\u8f6c\u6362PDF\u50a8\u5b58\u5904\u7406\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)jsonResult));
            }
            catch (Exception e) {
                log.error("error=", (Throwable)e);
            }
            return Either.right((Object)"\u5904\u7406\u5b8c\u6210.");
        }
        if (InvoiceFileTypeEnum.TYPE_OF_OFD.getSuffix().equalsIgnoreCase(invoiceFileEntity.getFileSuffix())) {
            log.info("OFD\u8f6c\u6362\u56fe\u7247\u9884\u89c8\u6587\u4ef6...");
            try {
                if (imgOptional.isPresent()) {
                    log.info("\u5df2\u6709JPG\u6587\u4ef6\uff0c\u4e0d\u8fdb\u884c\u8f6c\u6362\u3002");
                    return Either.left((Object)"\u5df2\u6709JPG\u6587\u4ef6\uff0c\u4e0d\u8fdb\u884c\u8f6c\u6362\u3002");
                }
                if (StringUtils.isBlank((CharSequence)invoiceFileEntity.getExt1())) {
                    log.info("OFD\u6570\u636e\u65e0\u56fe\u7247\u4e0b\u8f7d\u5730\u5740\u3002");
                    return Either.left((Object)"OFD\u6570\u636e\u65e0\u56fe\u7247\u4e0b\u8f7d\u5730\u5740\u3002");
                }
                File file = new File(CommonUtils.genUUID() + ".png");
                FileUtils.copyURLToFile((URL)new URL(invoiceFileEntity.getExt1()), (File)file);
                String fileEncode = Base64Encoder.encode((byte[])Files.readAllBytes(file.toPath()));
                fileStoreRequest.setFileEncode(fileEncode);
                fileStoreRequest.setFileName(invoiceCodeNo + ".jpg");
                fileStoreRequest.setGenPreviewFile(false);
                JsonResult jsonResult = this.upload_V2(fileStoreRequest);
                log.info("OFD\u8f6c\u6362\u56fe\u7247\u50a8\u5b58\u5904\u7406\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)jsonResult));
                file.delete();
            }
            catch (Exception e) {
                log.error("error=", (Throwable)e);
            }
            return Either.right((Object)"\u5904\u7406\u5b8c\u6210.");
        }
        return Either.left((Object)"");
    }

    public ByteArrayOutputStream genHtml2Pdf(String htmlContent) throws Exception {
        Document htmlDoc = Jsoup.parse((String)htmlContent);
        HtmlToPdfRenderBuilder openhttptopdfRenderBuilder = null;
        PdfRendererBuilder pdfRendererBuilder = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            openhttptopdfRenderBuilder = HtmlToPdfRendererFactory.getPdfRendererBuilderInstance();
            pdfRendererBuilder = openhttptopdfRenderBuilder.getPdfRendererBuilder();
            try {
                W3CDom w3cDom = new W3CDom();
                org.w3c.dom.Document w3cDoc = w3cDom.fromJsoup(htmlDoc);
                pdfRendererBuilder.withW3cDocument(w3cDoc, "/");
                pdfRendererBuilder.toStream((OutputStream)out);
                pdfRendererBuilder.run();
            }
            catch (Exception e) {
                log.error(htmlDoc.toString());
                throw e;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            HtmlToPdfRendererFactory.returnPdfBoxRenderer((HtmlToPdfRenderBuilder)openhttptopdfRenderBuilder);
        }
        PDDocument pdDoc = PDDocument.load((byte[])out.toByteArray());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pdDoc.save((OutputStream)baos);
        pdDoc.close();
        return baos;
    }

    private String downFile(String filePath, String storeMethod) {
        log.info("downFile filePath:{},storeMethod:{}", (Object)filePath, (Object)storeMethod);
        try {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)storeMethod, (CharSequence[])new CharSequence[]{"0", "NAS"})) {
                File newFile = new File(filePath);
                if (newFile.exists()) {
                    byte[] fileByte = FileUtils.readFileToByteArray((File)newFile);
                    return Base64.encodeBase64String((byte[])fileByte);
                }
            } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)storeMethod, (CharSequence[])new CharSequence[]{"1", "FTP"})) {
                File newFile;
                String fileName = filePath.substring(filePath.lastIndexOf("\\") + 1);
                String fileDir = filePath.substring(0, filePath.lastIndexOf("\\"));
                boolean result = this.ftpService.downloadFile(fileDir, fileName, this.fileStoreProperties.getNasTmpDir());
                if (result && (newFile = new File(this.fileStoreProperties.getNasTmpDir() + fileName)).exists()) {
                    byte[] fileByte = FileUtils.readFileToByteArray((File)newFile);
                    return Base64.encodeBase64String((byte[])fileByte);
                }
            }
        }
        catch (Exception e) {
            log.error("downFile error filePath:{}, storeMethod:{}", new Object[]{filePath, storeMethod, e});
        }
        return null;
    }

    private boolean removeFile(String filePath, String storeMethod) {
        log.info("removeFile filePath:{},storeMethod:{}", (Object)filePath, (Object)storeMethod);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)storeMethod, (CharSequence[])new CharSequence[]{"0", "NAS"})) {
            File newFile = new File(filePath);
            if (newFile.exists()) {
                newFile.delete();
            }
            return true;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)storeMethod, (CharSequence[])new CharSequence[]{"1", "FTP"})) {
            try {
                String fileName = filePath.substring(filePath.lastIndexOf("\\") + 1);
                String fileDir = filePath.substring(0, filePath.lastIndexOf("\\"));
                this.ftpService.removeFile(fileDir, fileName);
                return true;
            }
            catch (Exception e) {
                log.error("removeFile fail filepath:{}", (Object)filePath, (Object)e);
            }
        }
        return false;
    }

    public void analysisOfdStore(AnalysisOfdResponse.OfdResponseResult ofdResponseResult, AnalysisOfdRequest analysisOfdRequest) {
        try {
            if (!"1".equals(analysisOfdRequest.getStorageType())) {
                return;
            }
            InvoiceMain invoiceMain = ofdResponseResult.getInvoiceMain();
            FileStoreRequest ofdFileStoreRequest = FileStoreRequest.builder().invoiceCode(invoiceMain.getInvoiceCode()).invoiceNo(invoiceMain.getInvoiceNo()).paperDrewDate(invoiceMain.getPaperDrewDate()).businessId(invoiceMain.getInvoiceCode() + invoiceMain.getInvoiceNo()).fileType(XfFileType.ATTACHMENTS.getFileType()).fileName(CommonUtils.genUUID() + ".ofd").fileEncode(analysisOfdRequest.getOfdEncode()).ext1(ofdResponseResult.getImageUrl()).build();
            JsonResult fileJsonResult = this.upload_V2(ofdFileStoreRequest);
            log.info("ofd\u89e3\u6790\u50a8\u5b58\u6587\u4ef6\u7ed3\u679c={}", (Object)JSON.toJSONString((Object)fileJsonResult));
        }
        catch (Exception e) {
            log.error("ofd\u89e3\u6790\u5e76\u50a8\u5b58\u6587\u4ef6\u9519\u8bef,error=", (Throwable)e);
        }
    }

    public void analysisXmlStore(VerificationResponse.VerificationResult verificationResult, AnalysisXmlRequest analysisXmlRequest) {
        try {
            if (!"1".equals(analysisXmlRequest.getStorageType())) {
                return;
            }
            InvoiceMain invoiceMain = verificationResult.getInvoiceMain();
            FileStoreRequest ofdFileStoreRequest = FileStoreRequest.builder().invoiceNo(invoiceMain.getInvoiceNo()).paperDrewDate(invoiceMain.getPaperDrewDate()).businessId(invoiceMain.getInvoiceNo()).fileType(XfFileType.ATTACHMENTS.getFileType()).fileName(CommonUtils.genUUID() + ".xml").fileEncode(analysisXmlRequest.getXmlEncode()).build();
            JsonResult fileJsonResult = this.upload_V2(ofdFileStoreRequest);
            log.info("xml\u89e3\u6790\u50a8\u5b58\u6587\u4ef6\u7ed3\u679c={}", (Object)JSON.toJSONString((Object)fileJsonResult));
        }
        catch (Exception e) {
            log.error("xml\u89e3\u6790\u5e76\u50a8\u5b58\u6587\u4ef6\u9519\u8bef,error=", (Throwable)e);
        }
    }

    private String getFilePath(FileStoreRequest fileStoreRequest, String fileSuffix) {
        StringBuilder filePath = new StringBuilder();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.fileStoreProperties.getFileDefalutMehtod(), (CharSequence[])new CharSequence[]{"NAS"})) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileStoreRequest.getBusinessType(), (CharSequence[])new CharSequence[]{BusinessTypeEnum.COST.getBusinessType()})) {
                filePath.append(this.fileStoreProperties.getNasuploadrootCost());
            } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileStoreRequest.getBusinessType(), (CharSequence[])new CharSequence[]{BusinessTypeEnum.NONE_BUSINESS.getBusinessType()})) {
                filePath.append(this.fileStoreProperties.getNasuploadrootNoneBusiness());
            } else {
                filePath.append(this.fileStoreProperties.getNasTmpDir());
            }
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.fileStoreProperties.getFileDefalutMehtod(), (CharSequence[])new CharSequence[]{"FTP"})) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileStoreRequest.getBusinessType(), (CharSequence[])new CharSequence[]{BusinessTypeEnum.COST.getBusinessType()})) {
                filePath.append(this.fileStoreProperties.getFtpuploadrootCost());
            } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileStoreRequest.getBusinessType(), (CharSequence[])new CharSequence[]{BusinessTypeEnum.NONE_BUSINESS.getBusinessType()})) {
                filePath.append(this.fileStoreProperties.getFtpuploadrootNoneBusiness());
            } else {
                filePath.append(this.fileStoreProperties.getFtpTmpDir());
            }
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileStoreRequest.getFileType(), (CharSequence[])new CharSequence[]{XfFileType.INVOICE.getFileType()})) {
            filePath.append(File.separatorChar).append(fileStoreRequest.getVenderId() == null ? "" : fileStoreRequest.getVenderId()).append(File.separatorChar).append(fileStoreRequest.getPaperDrewDate()).append(File.separatorChar);
        }
        return filePath.toString();
    }

    public Either<String, FileViewResponse> filePreview(FileViewRequest fileViewRequest) {
        try {
            TXfInvoiceFileEntity tXfInvoiceFileEntity = new TXfInvoiceFileEntity();
            tXfInvoiceFileEntity.setInvoiceNoCode(fileViewRequest.getBusinessDataId());
            List list = this.tXfInvoiceFileService.findList(tXfInvoiceFileEntity);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
            }
            Optional<TXfInvoiceFileEntity> xmlOptional = list.stream().filter(s -> InvoiceFileTypeEnum.TYPE_OF_XML.getSuffix().equals(s.getFileSuffix())).findFirst();
            if (xmlOptional.isPresent()) {
                return this.xmlPreview(fileViewRequest);
            }
            Optional<TXfInvoiceFileEntity> pdfOptional = list.stream().filter(s -> InvoiceFileTypeEnum.TYPE_OF_PDF.getSuffix().equals(s.getFileSuffix())).findFirst();
            Optional<TXfInvoiceFileEntity> ofdOptional = list.stream().filter(s -> InvoiceFileTypeEnum.TYPE_OF_OFD.getSuffix().equals(s.getFileSuffix())).findFirst();
            if (pdfOptional.isPresent() || ofdOptional.isPresent()) {
                return this.pdfPreview(fileViewRequest);
            }
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
        }
        catch (Exception e) {
            log.error("error=", (Throwable)e);
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
        }
    }

    public Either<String, FileViewResponse> pdfPreview(FileViewRequest fileViewRequest) {
        if (fileViewRequest == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{fileViewRequest.getBusinessDataId()})) {
            return Either.left((Object)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
        }
        try {
            Either downEither;
            Optional<TXfInvoiceFileEntity> imgOptional;
            log.info("\u8fdb\u5165PDF\u9884\u89c8:{}", (Object)JSON.toJSONString((Object)fileViewRequest));
            TXfInvoiceFileEntity tXfInvoiceFileEntity = new TXfInvoiceFileEntity();
            tXfInvoiceFileEntity.setInvoiceNoCode(fileViewRequest.getBusinessDataId());
            List list = this.tXfInvoiceFileService.findList(tXfInvoiceFileEntity);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u6570\u636e\u3002");
            }
            Optional<TXfInvoiceFileEntity> pdfOptional = list.stream().filter(s -> InvoiceFileTypeEnum.TYPE_OF_PDF.getSuffix().equals(s.getFileSuffix())).findFirst();
            TXfInvoiceFileEntity _tXfInvoiceFileEntity = pdfOptional.orElse((imgOptional = list.stream().filter(s -> StringUtils.equalsAny((CharSequence)s.getFileSuffix(), (CharSequence[])new CharSequence[]{InvoiceFileTypeEnum.TYPE_OF_JPG.getSuffix(), InvoiceFileTypeEnum.TYPE_OF_JPEG.getSuffix()})).findFirst()).orElse(null));
            if (_tXfInvoiceFileEntity == null) {
                return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u6570\u636e\u3002");
            }
            String fileType = InvoiceFileTypeEnum.TYPE_OF_PDF.getSuffix();
            String mediaType = "data:application/pdf;base64,";
            if (imgOptional.isPresent()) {
                mediaType = "data:image/jpeg;base64,";
                fileType = InvoiceFileTypeEnum.TYPE_OF_JPG.getSuffix();
            }
            if ((downEither = this.downFile(String.valueOf(_tXfInvoiceFileEntity.getId()))).isLeft()) {
                log.error("\u4e0b\u8f7dPDF\u6e90\u6587\u4ef6\u5931\u8d25:{}", downEither.getLeft());
                return Either.left((Object)downEither.getLeft());
            }
            FileViewResponse fileViewResponse = FileViewResponse.builder().downPath("download/" + fileViewRequest.getBusinessDataId()).fileEncode(mediaType + ((FileStoreResponse)downEither.get()).getFileEncode()).fileName(_tXfInvoiceFileEntity.getFileName()).fileType(fileType).build();
            return Either.right((Object)fileViewResponse);
        }
        catch (Exception e) {
            log.error("error=", (Throwable)e);
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u6570\u636e\u3002");
        }
    }

    public Either<String, FileViewResponse> xmlPreview(FileViewRequest fileViewRequest) {
        if (fileViewRequest == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{fileViewRequest.getBusinessDataId()})) {
            return Either.left((Object)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
        }
        log.info("\u8fdb\u5165XML\u9884\u89c8:{}", (Object)JSON.toJSONString((Object)fileViewRequest));
        TDxRecordInvoiceEntity tDxRecordInvoiceEntity = new TDxRecordInvoiceEntity();
        tDxRecordInvoiceEntity.setUuid(fileViewRequest.getBusinessDataId());
        tDxRecordInvoiceEntity = this.tDxRecordInvoiceService.selectOne(tDxRecordInvoiceEntity);
        if (tDxRecordInvoiceEntity == null || tDxRecordInvoiceEntity.getId() == null) {
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u6570\u636e\u3002");
        }
        TDxRecordInvoiceDetailEntity tDxRecordInvoiceDetailEntity = new TDxRecordInvoiceDetailEntity();
        tDxRecordInvoiceDetailEntity.setUuid(fileViewRequest.getBusinessDataId());
        List detailEntityList = this.tDxRecordInvoiceDetailService.selectList(tDxRecordInvoiceDetailEntity);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("invoiceMain", tDxRecordInvoiceEntity);
        dataMap.put("invoiceDetails", detailEntityList);
        TXfInvoiceFileEntity tXfInvoiceFileEntity = new TXfInvoiceFileEntity();
        tXfInvoiceFileEntity.setInvoiceNoCode(fileViewRequest.getBusinessDataId());
        tXfInvoiceFileEntity.setFileSuffix(InvoiceFileTypeEnum.TYPE_OF_XML.getSuffix());
        List list = this.tXfInvoiceFileService.findList(tXfInvoiceFileEntity);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u6570\u636e\u3002");
        }
        FileViewResponse fileViewResponse = FileViewResponse.builder().downPath("download/" + fileViewRequest.getBusinessDataId()).fileName(((TXfInvoiceFileEntity)list.get(0)).getFileName()).dataMap(dataMap).fileType(InvoiceFileTypeEnum.TYPE_OF_XML.getSuffix()).build();
        return Either.right((Object)fileViewResponse);
    }

    public Either<String, FileStoreResponse> downFile(String id) {
        TXfInvoiceFileEntity invoiceFileEntity = this.tXfInvoiceFileService.queryById(id);
        if (invoiceFileEntity == null) {
            return Either.left((Object)"\u67e5\u65e0\u6b64\u7968\uff01");
        }
        String fileEncode = this.downFile(invoiceFileEntity.getPath(), invoiceFileEntity.getStorage() + "");
        if (StringUtils.isBlank((CharSequence)fileEncode)) {
            return Either.left((Object)"\u672a\u6210\u529f\u83b7\u53d6\u5230\u6587\u4ef6\uff01");
        }
        FileStoreResponse fileStoreResponse = FileStoreResponse.builder().fileEncode(fileEncode).fileName(invoiceFileEntity.getFileName()).fileSuffix(invoiceFileEntity.getFileSuffix()).build();
        return Either.right((Object)fileStoreResponse);
    }

    public Either<String, FileStoreResponse> downInvoiceSourceFile(String invoiceNoCode) {
        Either either = this.getInvoiceSourceFile(invoiceNoCode);
        if (either.isLeft()) {
            return Either.left((Object)either.getLeft());
        }
        Long id = ((Optional)either.get()).orElse(new TXfInvoiceFileEntity()).getId();
        return this.downFile(String.valueOf(id));
    }

    public Either<String, Optional<TXfInvoiceFileEntity>> getInvoiceSourceFile(String invoiceNoCode) {
        try {
            if (StringUtils.isBlank((CharSequence)invoiceNoCode)) {
                return Either.left((Object)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
            }
            TXfInvoiceFileEntity tXfInvoiceFileEntity = new TXfInvoiceFileEntity();
            tXfInvoiceFileEntity.setInvoiceNoCode(invoiceNoCode);
            List list = this.tXfInvoiceFileService.findList(tXfInvoiceFileEntity);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
            }
            Optional<TXfInvoiceFileEntity> xmlOptional = list.stream().filter(s -> InvoiceFileTypeEnum.TYPE_OF_XML.getSuffix().equals(s.getFileSuffix())).findFirst();
            if (xmlOptional.isPresent()) {
                return Either.right(xmlOptional);
            }
            Optional<TXfInvoiceFileEntity> ofdOptional = list.stream().filter(s -> InvoiceFileTypeEnum.TYPE_OF_OFD.getSuffix().equals(s.getFileSuffix())).findFirst();
            if (ofdOptional.isPresent()) {
                return Either.right(ofdOptional);
            }
            Optional<TXfInvoiceFileEntity> pdfOptional = list.stream().filter(s -> InvoiceFileTypeEnum.TYPE_OF_PDF.getSuffix().equals(s.getFileSuffix())).findFirst();
            if (pdfOptional.isPresent()) {
                return Either.right(pdfOptional);
            }
            Optional optional = list.stream().findFirst();
            return Either.right(optional);
        }
        catch (Exception e) {
            log.error("error=", (Throwable)e);
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
        }
    }

    public JsonResult<String> remove(String id) {
        TXfInvoiceFileEntity invoiceFileEntity = this.tXfInvoiceFileService.queryById(id);
        if (invoiceFileEntity == null) {
            return JsonResult.error((String)"\u67e5\u65e0\u6b64\u7968\uff01");
        }
        boolean result = this.removeFile(invoiceFileEntity.getPath(), invoiceFileEntity.getStorage() + "");
        return result ? JsonResult.ok((String)"\u53d1\u7968\u5220\u9664\u6210\u529f") : JsonResult.error((String)"\u53d1\u7968\u5220\u9664\u5931\u8d25");
    }

    public void pdfDiscernStore(VerificationResponse.VerificationResult verificationResult, DiscernRequest discernRequest) {
        try {
            if (!"1".equals(discernRequest.getStorageType())) {
                return;
            }
            InvoiceMain invoiceMain = verificationResult.getInvoiceMain();
            FileStoreRequest ofdFileStoreRequest = FileStoreRequest.builder().invoiceNo(invoiceMain.getInvoiceNo()).invoiceCode(invoiceMain.getInvoiceCode()).paperDrewDate(invoiceMain.getPaperDrewDate()).businessId(invoiceMain.getInvoiceNo()).fileType(XfFileType.ATTACHMENTS.getFileType()).fileName(CommonUtils.genUUID() + ".pdf").fileEncode(discernRequest.getFile()).build();
            JsonResult fileJsonResult = this.upload_V2(ofdFileStoreRequest);
            log.info("PDF\u89e3\u6790\u50a8\u5b58\u6587\u4ef6\u7ed3\u679c={}", (Object)JSON.toJSONString((Object)fileJsonResult));
        }
        catch (Exception e) {
            log.error("PDF\u89e3\u6790\u5e76\u50a8\u5b58\u6587\u4ef6\u9519\u8bef,error=", (Throwable)e);
        }
    }
}

