/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.customs.CustomsTaxCheckRequest;
import com.xforceplus.evat.common.modules.taxware.CustomsTaxService;
import com.xforceplus.evat.common.utils.DateUtils;
import com.xforceplus.evat.domain.TDxCustomsEntity;
import com.xforceplus.evat.domain.TDxCustomsLogEntity;
import com.xforceplus.evat.domain.TDxCustomsTaskEntity;
import com.xforceplus.evat.domain.checkresult.CheckResultEntity;
import com.xforceplus.evat.enums.AuthResultEnum;
import com.xforceplus.evat.enums.AuthUseEnum;
import com.xforceplus.evat.enums.CheckResultEnum;
import com.xforceplus.evat.enums.CronStatusEnum;
import com.xforceplus.evat.enums.InvoiceCheckEnum;
import com.xforceplus.evat.modules.mapper.TDxCustomsLogMapper;
import com.xforceplus.evat.modules.mapper.TDxCustomsMapper;
import com.xforceplus.evat.modules.mapper.TDxCustomsTaskMapper;
import com.xforceplus.evat.modules.service.TDXCustomsSummonsService;
import com.xforceplus.evat.modules.service.TDxCustomsService;
import com.xforceplus.evat.modules.service.TDxCustomsTaskService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TDxCustomsTaskServiceImpl
implements TDxCustomsTaskService {
    private static final Logger log = LoggerFactory.getLogger(TDxCustomsTaskServiceImpl.class);
    @Autowired
    private TDxCustomsTaskMapper tDxCustomsTaskMapper;
    @Autowired
    private TDxCustomsMapper tDxCustomsMapper;
    @Autowired
    private TDxCustomsLogMapper tDxCustomsLogMapper;
    @Autowired
    CustomsTaxService customsTaxService;
    @Autowired
    TDxCustomsService tDxCustomsService;
    @Autowired
    private TDXCustomsSummonsService summonsService;
    private final Integer CHECK_NUM = 8;

    public TDxCustomsTaskEntity queryObject(Long id) {
        return (TDxCustomsTaskEntity)this.tDxCustomsTaskMapper.selectById((Serializable)id);
    }

    public List<TDxCustomsTaskEntity> queryList(Map<String, Object> map) {
        return this.tDxCustomsTaskMapper.selectByMap(map);
    }

    public int save(TDxCustomsTaskEntity tDxCustomsLog) {
        return this.tDxCustomsTaskMapper.insert((Object)tDxCustomsLog);
    }

    public int update(TDxCustomsTaskEntity tDxCustomsLog) {
        return this.tDxCustomsTaskMapper.updateById((Object)tDxCustomsLog);
    }

    public int saveTask(String params) {
        log.info("\u4fdd\u5b58\u6d77\u5173\u7968\u4efb\u52a1\u6570\u636e:{}", (Object)params);
        TDxCustomsTaskEntity entity1 = (TDxCustomsTaskEntity)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)params), TDxCustomsTaskEntity.class);
        return this.tDxCustomsTaskMapper.insert((Object)entity1);
    }

    public void makeCustomsTask() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TDxCustomsTaskEntity::getAuthUse, Arrays.asList("1", "3", "10", "30"));
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TDxCustomsTaskEntity::getStatus, (Object)"0")).lt(TDxCustomsTaskEntity::getNum, (Object)5)).orderByAsc(TDxCustomsTaskEntity::getCreateTime);
        Page page = new Page(1L, 50L);
        Page iPage = (Page)this.tDxCustomsTaskMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        log.info("CustomsTaskScheduler-\u672c\u6b21\u6267\u884c\u4efb\u52a1\u6570\u91cf:{}", (Object)iPage.getRecords().size());
        iPage.getRecords().forEach(x -> {
            CustomsTaxCheckRequest request = (CustomsTaxCheckRequest)JSON.toJavaObject((JSON)JSON.parseObject((String)x.getSendMsg()), CustomsTaxCheckRequest.class);
            try {
                log.info("\u6d77\u5173\u7968\u52fe\u9009\u5b9a\u65f6\u4efb\u52a1\u53d1\u8d77\u8bf7\u6c42:{}", JSON.toJSON((Object)request));
                JsonResult result = this.tDxCustomsService.checkTask(request);
                Thread.sleep(100L);
                this.saveCustomsLog(x, result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void makeCustomsTaskResult() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TDxCustomsTaskEntity::getStatus, (Object)"1")).lt(TDxCustomsTaskEntity::getNum, (Object)this.CHECK_NUM)).isNotNull(TDxCustomsTaskEntity::getTaskId)).orderByAsc(TDxCustomsTaskEntity::getCreateTime);
        Page page = new Page(1L, 50L);
        Page iPage = (Page)this.tDxCustomsTaskMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        log.info("CustomsTaskResultScheduler-\u672c\u6b21\u6267\u884c\u4efb\u52a1\u6570\u91cf:{},", (Object)iPage.getRecords().size());
        iPage.getRecords().forEach(x -> {
            try {
                log.info("\u6d77\u5173\u7968\u52fe\u9009\u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6\u7ed3\u679c\u8bf7\u6c42:{}", (Object)x.getTaskId());
                if (Objects.nonNull(x.getCustomsId())) {
                    TDxCustomsEntity customsEntity = (TDxCustomsEntity)this.tDxCustomsMapper.selectById((Serializable)x.getCustomsId());
                    JsonResult result = this.customsTaxService.checkResult(x.getTaskId());
                    CheckResultEntity checkResultEntity = (CheckResultEntity)JSON.toJavaObject((JSON)JSON.parseObject((String)result.getData().toString()), CheckResultEntity.class);
                    if (Objects.nonNull(checkResultEntity)) {
                        if (StringUtils.equals((CharSequence)CheckResultEnum.RESULT_SUCCESS.getCode(), (CharSequence)checkResultEntity.getCode()) && checkResultEntity.getResult().isTaskFlag()) {
                            if (StringUtils.equals((CharSequence)AuthUseEnum.AUTHUSE_01.getCode(), (CharSequence)checkResultEntity.getResult().getCheckResult().getAuthUse())) {
                                this.summonsService.updateIsCheck(customsEntity.getCustomsNo(), InvoiceCheckEnum.CHECK_4.getCode());
                                customsEntity.setCheckTime(checkResultEntity.getResult().getCheckResult().getAuthTime());
                                if (StringUtils.equals((CharSequence)AuthResultEnum.AUTHRESULT_1.getCode(), (CharSequence)checkResultEntity.getResult().getCheckResult().getAuthResult())) {
                                    customsEntity.setIsCheck(InvoiceCheckEnum.CHECK_4.getCode().toString());
                                } else if (StringUtils.equals((CharSequence)AuthResultEnum.AUTHRESULT_N1.getCode(), (CharSequence)checkResultEntity.getResult().getCheckResult().getAuthResult())) {
                                    customsEntity.setIsCheck(InvoiceCheckEnum.CHECK_5.getCode().toString());
                                }
                            } else if (StringUtils.equals((CharSequence)AuthUseEnum.AUTHUSE_10.getCode(), (CharSequence)checkResultEntity.getResult().getCheckResult().getAuthUse())) {
                                if (StringUtils.isEmpty((CharSequence)checkResultEntity.getResult().getCheckResult().getAuthTime())) {
                                    customsEntity.setUnCheckTime(DateUtils.format((Date)new Date()));
                                } else {
                                    customsEntity.setUnCheckTime(checkResultEntity.getResult().getCheckResult().getAuthTime());
                                }
                                if (StringUtils.equals((CharSequence)AuthResultEnum.AUTHRESULT_1.getCode(), (CharSequence)checkResultEntity.getResult().getCheckResult().getAuthResult())) {
                                    this.summonsService.updateIsCheck(customsEntity.getCustomsNo(), InvoiceCheckEnum.CHECK_9.getCode());
                                    customsEntity.setIsCheck(InvoiceCheckEnum.CHECK_9.getCode().toString());
                                } else if (StringUtils.equals((CharSequence)AuthResultEnum.AUTHRESULT_N1.getCode(), (CharSequence)checkResultEntity.getResult().getCheckResult().getAuthResult())) {
                                    customsEntity.setIsCheck(InvoiceCheckEnum.CHECK_N1.getCode().toString());
                                } else if (StringUtils.equals((CharSequence)AuthResultEnum.AUTHRESULT_0.getCode(), (CharSequence)checkResultEntity.getResult().getCheckResult().getAuthResult())) {
                                    customsEntity.setIsCheck(InvoiceCheckEnum.CHECK_0.getCode().toString());
                                }
                            }
                            customsEntity.setAuthRemark(checkResultEntity.getResult().getCheckResult().getAuthRemark());
                            customsEntity.setCheckPurpose(checkResultEntity.getResult().getCheckResult().getAuthUse());
                            customsEntity.setTaxPeriod(checkResultEntity.getResult().getCheckResult().getTaxPeriod());
                            if (StringUtils.isNotEmpty((CharSequence)checkResultEntity.getResult().getCheckResult().getEffectiveTaxAmount())) {
                                customsEntity.setEffectiveTaxAmount(new BigDecimal(checkResultEntity.getResult().getCheckResult().getEffectiveTaxAmount()));
                            }
                            customsEntity.setUpdateTime(new Date());
                            this.tDxCustomsMapper.updateById((Object)customsEntity);
                            x.setStatus(CronStatusEnum.CRONSTATUS_2.getCode());
                        } else if (StringUtils.equals((CharSequence)CheckResultEnum.RESULT_FAIL.getCode(), (CharSequence)checkResultEntity.getCode())) {
                            if (StringUtils.equals((CharSequence)InvoiceCheckEnum.CHECK_3.getCode().toString(), (CharSequence)customsEntity.getIsCheck())) {
                                customsEntity.setIsCheck(InvoiceCheckEnum.CHECK_5.getCode().toString());
                            } else if (StringUtils.equals((CharSequence)InvoiceCheckEnum.CHECK_0.getCode().toString(), (CharSequence)customsEntity.getIsCheck())) {
                                customsEntity.setIsCheck(InvoiceCheckEnum.CHECK_N1.getCode().toString());
                            }
                            customsEntity.setUpdateTime(new Date());
                            this.tDxCustomsMapper.updateById((Object)customsEntity);
                            x.setStatus(CronStatusEnum.CRONSTATUS_2.getCode());
                        }
                    }
                    x.setNum(Integer.valueOf(x.getNum() + 1));
                    x.setUpdateTime(new Date());
                    x.setResultMsg(Objects.nonNull(checkResultEntity) ? JSON.toJSONString((Object)checkResultEntity) : JSON.toJSONString((Object)result));
                    if (x.getNum() == this.CHECK_NUM) {
                        x.setStatus(CronStatusEnum.CRONSTATUS_2.getCode());
                    }
                    this.tDxCustomsTaskMapper.updateById(x);
                    this.saveCustomsResultLog(customsEntity, checkResultEntity, x.getTaskId());
                }
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public Object checkRequest(String params) {
        return null;
    }

    public CustomsTaxCheckRequest copyCustomsTax(TDxCustomsTaskEntity entity) {
        CustomsTaxCheckRequest request = new CustomsTaxCheckRequest();
        request.setCustomsId(entity.getCustomsId());
        request.setCustomsPaymentNo(entity.getCustomsNo());
        request.setTaxNo(entity.getBuyerTaxNo());
        request.setEffectiveTaxAmount(entity.getEffectiveTaxAmount());
        request.setDateIssued(entity.getDateIssued());
        request.setAuthUse(entity.getAuthUse());
        request.setTaxPeriod(entity.getTaxPeriod());
        request.setBb("4");
        request.setDebug("1");
        return request;
    }

    public void saveCustomsLog(TDxCustomsTaskEntity entity, JsonResult result) {
        TDxCustomsLogEntity logEntity = new TDxCustomsLogEntity();
        logEntity.setCustomsId(entity.getCustomsId());
        logEntity.setCustomsNo(entity.getCustomsNo());
        logEntity.setCheckTime(new Date());
        logEntity.setType(entity.getAuthUse());
        logEntity.setUserName("\u7cfb\u7edf\u64cd\u4f5c");
        if (result.isSuccess()) {
            JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)result.getData()));
            logEntity.setTaskId(jsonObject.getString("taskId"));
        }
        this.tDxCustomsLogMapper.insert((Object)logEntity);
    }

    public void saveCustomsResultLog(TDxCustomsEntity customsEntity, CheckResultEntity checkResultEntity, String taskId) {
        TDxCustomsLogEntity logEntity = new TDxCustomsLogEntity();
        logEntity.setCustomsId(customsEntity.getId());
        logEntity.setCustomsNo(customsEntity.getCustomsNo());
        logEntity.setType(customsEntity.getCheckPurpose());
        logEntity.setResultMsg(Objects.nonNull(checkResultEntity) ? JSON.toJSONString((Object)checkResultEntity) : "\u83b7\u53d6\u7ed3\u679c\u5931\u8d25");
        if (Objects.nonNull(checkResultEntity)) {
            if (StringUtils.equals((CharSequence)"1", (CharSequence)checkResultEntity.getCode())) {
                logEntity.setResultStatus(checkResultEntity.getResult().getCheckResult().getAuthResult());
                logEntity.setType(customsEntity.getCheckPurpose());
                logEntity.setCheckResultTime(checkResultEntity.getResult().getCheckResult().getAuthTime());
            } else {
                logEntity.setResultStatus("-1");
            }
        } else {
            logEntity.setResultStatus("-1");
        }
        logEntity.setTaskId(taskId);
        logEntity.setCreateTime(new Date());
        logEntity.setUserName("\u7cfb\u7edf\u64cd\u4f5c");
        this.tDxCustomsLogMapper.insert((Object)logEntity);
    }
}

