/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.ele.parse.entity.FPEntity;
import com.ele.parse.utils.FPUtils;
import com.ele.parse.utils.InvokeUtil;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.file.FileAnalysisRequest;
import com.xforceplus.evat.common.domain.file.FileAnalysisResponse;
import com.xforceplus.evat.common.domain.verify.AnalysisOfdRequest;
import com.xforceplus.evat.common.domain.verify.AnalysisOfdResponse;
import com.xforceplus.evat.common.domain.verify.AnalysisXmlRequest;
import com.xforceplus.evat.common.domain.verify.AnalysisXmlResult;
import com.xforceplus.evat.common.domain.verify.InvoiceMain;
import com.xforceplus.evat.common.modules.verify.OfdService;
import com.xforceplus.evat.common.modules.verify.XmlService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RequestMapping(value={"/inner/file/analysis"})
@RestController
public class FileAnalysisController {
    private static final Logger log = LoggerFactory.getLogger(FileAnalysisController.class);
    @Autowired
    private OfdService ofdService;
    @Autowired
    private XmlService xmlService;

    @RequestMapping(value={""})
    public JsonResult<FileAnalysisResponse> parse(@RequestBody FileAnalysisRequest fileAnalysisRequest) {
        FileAnalysisRequest newFileAnalysisRequest = new FileAnalysisRequest();
        BeanUtils.copyProperties((Object)fileAnalysisRequest, (Object)newFileAnalysisRequest);
        log.info("parse newFileAnalysisRequest:{}", (Object)newFileAnalysisRequest);
        JsonResult result = FileAnalysisController.valid((FileAnalysisRequest)newFileAnalysisRequest);
        if (result != null) {
            return result;
        }
        FileAnalysisResponse fileAnalysisResponse = null;
        log.info("\u6587\u4ef6\u89e3\u6790\uff1a{}", (Object)JSON.toJSONString((Object)newFileAnalysisRequest));
        if (newFileAnalysisRequest.getFileType() != null && newFileAnalysisRequest.getFileType().endsWith("ofd")) {
            AnalysisOfdRequest analysisOfdRequest = new AnalysisOfdRequest();
            analysisOfdRequest.setOfdEncode(newFileAnalysisRequest.getFile());
            analysisOfdRequest.setSystemOrig(newFileAnalysisRequest.getSystemOrig());
            JsonResult jsonResult = this.ofdService.analysisOfd(analysisOfdRequest);
            if (jsonResult.isFail()) {
                log.info("\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)jsonResult));
                return JsonResult.error((String)"\u89e3\u6790\u5931\u8d25");
            }
            InvoiceMain invoiceMain = ((AnalysisOfdResponse.OfdResponseResult)jsonResult.getData()).getInvoiceMain();
            fileAnalysisResponse = new FileAnalysisResponse();
            fileAnalysisResponse.setAmount(invoiceMain.getAmountWithoutTax());
            BeanUtils.copyProperties((Object)invoiceMain, (Object)fileAnalysisResponse);
        } else if (newFileAnalysisRequest.getFileType() != null && newFileAnalysisRequest.getFileType().endsWith("xml")) {
            AnalysisXmlRequest analysisXmlRequest = new AnalysisXmlRequest();
            analysisXmlRequest.setXmlEncode(newFileAnalysisRequest.getFile());
            analysisXmlRequest.setSystemOrig(newFileAnalysisRequest.getSystemOrig());
            JsonResult jsonResult = this.xmlService.analysisXml(analysisXmlRequest);
            if (jsonResult.isFail()) {
                log.info("\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)jsonResult));
                return JsonResult.error((String)"\u89e3\u6790\u5931\u8d25");
            }
            AnalysisXmlResult.InvoiceMainDTO invoiceMainDTO = ((AnalysisXmlResult)jsonResult.getData()).getInvoiceMain();
            fileAnalysisResponse = new FileAnalysisResponse(invoiceMainDTO.getPaperDrewDate(), invoiceMainDTO.getInvoiceNo(), null, null, invoiceMainDTO.getAmountWithTax(), invoiceMainDTO.getAmountWithoutTax(), invoiceMainDTO.getSellerTaxNo());
        } else if (newFileAnalysisRequest.getFileType() != null && newFileAnalysisRequest.getFileType().endsWith("pdf")) {
            String base64Data = newFileAnalysisRequest.getFile();
            FPUtils fpUtiles = new FPUtils();
            FPEntity fp = fpUtiles.setFPAttri(base64Data, null, true, false, false);
            InvokeUtil.trimParse((Object)fp);
            log.info("pdf\u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)fp));
            String paperDrewDate = FileAnalysisController.formatPaperDrewDate((String)fp.getKprq());
            fileAnalysisResponse = new FileAnalysisResponse(paperDrewDate, fp.getFphm(), fp.getFpdm(), fp.getJym(), fp.getJshj(), fp.getHjje(), fp.getSeller_nsrsbh());
        }
        log.info("\u89e3\u6790\u7ed3\u679c\u8fd4\u56deBMS\u7cfb\u7edf\uff1a{}", (Object)JSON.toJSONString((Object)JsonResult.data(fileAnalysisResponse)));
        return JsonResult.data(fileAnalysisResponse);
    }

    private static JsonResult<FileAnalysisResponse> valid(FileAnalysisRequest fileAnalysisRequest) {
        if (fileAnalysisRequest == null) {
            return JsonResult.error((String)"\u53c2\u6570\u6709\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)fileAnalysisRequest.getFile())) {
            return JsonResult.error((String)"\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)fileAnalysisRequest.getFileType())) {
            return JsonResult.error((String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.endsWithAny((CharSequence)fileAnalysisRequest.getFileType(), (CharSequence[])new CharSequence[]{"pdf", "ofd", "xml"})) {
            return JsonResult.error((String)"\u65e0\u6cd5\u89e3\u6790\u7684\u6587\u4ef6\u7c7b\u578b\uff01");
        }
        return null;
    }

    private static String formatPaperDrewDate(String paperDrewDate) {
        try {
            if (paperDrewDate.indexOf("-") > -1) {
                DateTime dt = DateUtil.parse((CharSequence)paperDrewDate, (String)"yyyy-MM-dd");
                paperDrewDate = DateUtil.format((Date)dt, (String)"yyyyMMdd");
            } else if (paperDrewDate.indexOf("\u5e74") > -1) {
                DateTime dt = DateUtil.parse((CharSequence)paperDrewDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                paperDrewDate = DateUtil.format((Date)dt, (String)"yyyyMMdd");
            }
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u683c\u5f0f\u5316\u6709\u8bef\uff1a{}", (Object)paperDrewDate);
        }
        return paperDrewDate;
    }
}

