/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.controller;

import com.alibaba.fastjson.JSON;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.verify.AnalysisOfdRequest;
import com.xforceplus.evat.common.domain.verify.AnalysisOfdResponse;
import com.xforceplus.evat.common.domain.verify.InvoiceMain;
import com.xforceplus.evat.common.domain.verify.VerificationRequest;
import com.xforceplus.evat.common.modules.verify.OfdService;
import com.xforceplus.evat.common.modules.verify.VerifyService;
import com.xforceplus.evat.modules.service.FileStoreService;
import com.xforceplus.evat.modules.service.InvoiceVerifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/janus/ofd"})
public class OfdController {
    private static final Logger log = LoggerFactory.getLogger(OfdController.class);
    @Autowired
    private OfdService ofdService;
    @Autowired
    private VerifyService verifyService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private InvoiceVerifyService invoiceVerifyService;

    @PostMapping
    public JsonResult analysisOfd(@RequestBody AnalysisOfdRequest analysisOfdRequest) {
        AnalysisOfdRequest newAnalysisOfdRequest = new AnalysisOfdRequest();
        BeanUtils.copyProperties((Object)analysisOfdRequest, (Object)newAnalysisOfdRequest);
        log.info("analysisOfd newAnalysisOfdRequest:{}", (Object)JSON.toJSONString((Object)newAnalysisOfdRequest));
        JsonResult jsonResult = this.ofdService.analysisOfd(newAnalysisOfdRequest);
        if (jsonResult.isFail()) {
            return jsonResult;
        }
        return jsonResult;
    }

    @PostMapping(value={"/verify"})
    public JsonResult analysisOfdSync(@RequestBody AnalysisOfdRequest analysisOfdRequest) {
        AnalysisOfdRequest newAnalysisOfdRequest = new AnalysisOfdRequest();
        BeanUtils.copyProperties((Object)analysisOfdRequest, (Object)newAnalysisOfdRequest);
        log.info("analysisOfdSync newAnalysisOfdRequest:{}", (Object)JSON.toJSONString((Object)newAnalysisOfdRequest));
        JsonResult jsonResult = this.ofdService.analysisOfd(newAnalysisOfdRequest);
        if (jsonResult.isFail()) {
            return jsonResult;
        }
        AnalysisOfdResponse.OfdResponseResult ofdResponseResult = (AnalysisOfdResponse.OfdResponseResult)jsonResult.getData();
        InvoiceMain invoiceMain = ofdResponseResult.getInvoiceMain();
        VerificationRequest verificationRequest = new VerificationRequest();
        verificationRequest.setInvoiceNo(invoiceMain.getInvoiceNo());
        verificationRequest.setInvoiceCode(invoiceMain.getInvoiceCode());
        verificationRequest.setPaperDrewDate(invoiceMain.getPaperDrewDate());
        verificationRequest.setCheckCode(invoiceMain.getCheckCode());
        verificationRequest.setAmountWithTax(invoiceMain.getAmountWithTax());
        verificationRequest.setAmount(invoiceMain.getAmountWithoutTax());
        verificationRequest.setSystemOrig(newAnalysisOfdRequest.getSystemOrig());
        JsonResult verifyJsonResult = this.invoiceVerifyService.invoiceVerifySync(verificationRequest);
        if (verifyJsonResult.isFail()) {
            return verifyJsonResult;
        }
        this.fileStoreService.analysisOfdStore(ofdResponseResult, newAnalysisOfdRequest);
        return verifyJsonResult;
    }
}

