/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.controller;

import com.alibaba.fastjson.JSON;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.verify.VerificationRequest;
import com.xforceplus.evat.common.modules.verify.VerifyService;
import com.xforceplus.evat.modules.service.InvoiceVerifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/janus/verify"})
public class VerifyController {
    private static final Logger log = LoggerFactory.getLogger(VerifyController.class);
    @Autowired
    private VerifyService verifyService;
    @Autowired
    private InvoiceVerifyService invoiceVerifyService;

    @PostMapping
    public JsonResult invoiceVerify(@RequestBody VerificationRequest verificationRequest) {
        VerificationRequest newVerificationRequest = new VerificationRequest();
        BeanUtils.copyProperties((Object)verificationRequest, (Object)newVerificationRequest);
        log.info("invoiceVerify newVerificationRequest:{}", (Object)JSON.toJSONString((Object)newVerificationRequest));
        return this.verifyService.invoiceVerify(newVerificationRequest);
    }

    @PostMapping(value={"/sync"})
    public JsonResult invoiceVerifySync(@RequestBody VerificationRequest verificationRequest) {
        VerificationRequest newVerificationRequest = new VerificationRequest();
        BeanUtils.copyProperties((Object)verificationRequest, (Object)newVerificationRequest);
        log.info("invoiceVerifySync newVerificationRequest:{}", (Object)JSON.toJSONString((Object)newVerificationRequest));
        return this.invoiceVerifyService.invoiceVerifySync(newVerificationRequest);
    }
}

