/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.SealedRecMessage;
import com.xforceplus.evat.common.constant.enums.InvoiceTypeEnum;
import com.xforceplus.evat.common.domain.bms.BmsFeedbackConfig;
import com.xforceplus.evat.common.domain.verify.BMSCheckResponse;
import com.xforceplus.evat.common.domain.verify.VerificationResponse;
import com.xforceplus.evat.common.utils.SignUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BMSVerifyResultHandler {
    private static final Logger log = LoggerFactory.getLogger(BMSVerifyResultHandler.class);
    @Autowired
    public BmsFeedbackConfig bmsFeedbackConfig;
    @Value(value="${spring.application.name}")
    public String appName;

    public void execute(SealedRecMessage sealedRecMessage) {
        try {
            String object = sealedRecMessage.getPayload().getObj().toString();
            log.info("===> receive tcp invoice verify message, message={}", (Object)JacksonUtil.getInstance().toJson((Object)object));
            VerificationResponse verificationResult = (VerificationResponse)JSON.parseObject((String)object, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            BMSCheckResponse bmsCheckResponse = new BMSCheckResponse();
            bmsCheckResponse.setSource(this.appName);
            bmsCheckResponse.setTimestamp(String.valueOf(System.currentTimeMillis()));
            bmsCheckResponse.setFormat("json");
            bmsCheckResponse.setAppName(this.appName);
            bmsCheckResponse.setVersion("1.0");
            if (verificationResult.isOK()) {
                BMSCheckResponse.Param param = new BMSCheckResponse.Param();
                BeanUtils.copyProperties((Object)((VerificationResponse.VerificationResult)verificationResult.getResult()).getInvoiceMain(), (Object)param);
                InvoiceTypeEnum.getResultCode((String)param.getInvoiceType()).ifPresent(resultCode -> param.setInvoiceType(resultCode));
                param.setItems(((VerificationResponse.VerificationResult)verificationResult.getResult()).getInvoiceDetails());
                param.setCode("0");
                param.setTaskId(verificationResult.getTaskId());
                bmsCheckResponse.setParam(param);
            } else {
                bmsCheckResponse.setParam(new BMSCheckResponse.Param("-1", verificationResult.getMessage(), verificationResult.getTaskId()));
            }
            bmsCheckResponse.setSign(SignUtils.getSign((String)bmsCheckResponse.getAppName(), (String)bmsCheckResponse.getSource(), (String)bmsCheckResponse.getTimestamp(), (String)bmsCheckResponse.getFormat(), (String)bmsCheckResponse.getVersion(), (String)JSON.toJSONString((Object)bmsCheckResponse.getParam()), (String)this.bmsFeedbackConfig.getAppSecret()));
            String data = JSON.toJSONString((Object)bmsCheckResponse);
            log.info("\u9a8c\u771f\u7ed3\u679c\u53cd\u9988BMS\uff1aurl={},data={}", (Object)this.bmsFeedbackConfig.getBmsVerifyFeedbackUrl(), (Object)data);
            String result = HttpRequest.post((String)this.bmsFeedbackConfig.getBmsVerifyFeedbackUrl()).body(data).execute().body();
            log.info("BMS\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c\u54cd\u5e94\uff1a{}", (Object)result);
        }
        catch (Exception e) {
            log.error("\u9a8c\u771f\u7ed3\u679c\u56de\u8c03BMS\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

