/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.customs.CustomsTaxCheckRequest;
import com.xforceplus.evat.common.domain.customs.CustomsTaxResultResponse;
import com.xforceplus.evat.common.modules.taxware.CustomsTaxService;
import com.xforceplus.evat.common.utils.DateUtils;
import com.xforceplus.evat.domain.TAcOrgEntity;
import com.xforceplus.evat.domain.TDxCustomsEntity;
import com.xforceplus.evat.domain.TDxCustomsTaskEntity;
import com.xforceplus.evat.enums.AccountStatusEnum;
import com.xforceplus.evat.enums.CronStatusEnum;
import com.xforceplus.evat.enums.SourceTypeEnum;
import com.xforceplus.evat.modules.mapper.TAcOrgMapper;
import com.xforceplus.evat.modules.mapper.TDxCustomsLogMapper;
import com.xforceplus.evat.modules.mapper.TDxCustomsMapper;
import com.xforceplus.evat.modules.mapper.TDxCustomsTaskMapper;
import com.xforceplus.evat.modules.service.TDxCustomsLogService;
import com.xforceplus.evat.modules.service.TDxCustomsService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TDxCustomsServiceImpl
implements TDxCustomsService {
    private static final Logger log = LoggerFactory.getLogger(TDxCustomsServiceImpl.class);
    @Autowired
    private CustomsTaxService customsTaxService;
    @Autowired
    private TDxCustomsLogMapper tDxCustomsLogMapper;
    @Autowired
    private TDxCustomsMapper tDxCustomsMapper;
    @Autowired
    private TDxCustomsTaskMapper tDxCustomsTaskMapper;
    @Autowired
    private TAcOrgMapper tAcOrgMapper;
    @Autowired
    private TDxCustomsLogService tDxCustomsLogService;

    public TDxCustomsEntity queryObject(Long id) {
        return (TDxCustomsEntity)this.tDxCustomsMapper.selectById((Serializable)id);
    }

    public List<TDxCustomsEntity> queryList(Map<String, Object> map) {
        return this.tDxCustomsMapper.selectByMap(map);
    }

    public int save(TDxCustomsEntity tDxCustomsLog) {
        return this.tDxCustomsMapper.insert((Object)tDxCustomsLog);
    }

    public int update(TDxCustomsEntity tDxCustomsLog) {
        return this.tDxCustomsMapper.updateById((Object)tDxCustomsLog);
    }

    public int saveCustoms(CustomsTaxResultResponse resultResponse) {
        log.info("\u6d77\u5173\u7f34\u6b3e\u4e66\u62b5\u6263\u4fe1\u606f\u4fdd\u5b58:{}", JSON.toJSON((Object)resultResponse));
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("customs_no", resultResponse.getCustomsPaymentNo());
        List entities = this.tDxCustomsMapper.selectByMap(queryMap);
        TDxCustomsEntity copyEntity = this.copyEntity(resultResponse);
        int status = 0;
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            copyEntity.setId(((TDxCustomsEntity)entities.stream().findFirst().get()).getId());
            copyEntity.setSourceType(SourceTypeEnum.SOURCE_00.getCode());
            copyEntity.setCompanyName(this.queryCompanyName(resultResponse.getBuyerTaxNo()));
            copyEntity.setUpdateTime(new Date());
            status = this.tDxCustomsMapper.updateById((Object)copyEntity);
        } else {
            copyEntity.setAccountStatus(AccountStatusEnum.ACCOUNT_00.getCode());
            copyEntity.setSourceType(SourceTypeEnum.SOURCE_00.getCode());
            copyEntity.setPushBmsStatus("0");
            copyEntity.setBillStatus("0");
            copyEntity.setCompanyName(this.queryCompanyName(resultResponse.getBuyerTaxNo()));
            copyEntity.setCreateTime(new Date());
            copyEntity.setUpdateTime(new Date());
            status = this.tDxCustomsMapper.insert((Object)copyEntity);
        }
        return status;
    }

    public JsonResult check(CustomsTaxCheckRequest request) {
        JsonResult requestResult = this.customsTaxService.check(request);
        this.tDxCustomsLogService.saveLog(request.getCustomsId(), request.getCustomsPaymentNo(), request.getAuthUse(), request.getUserId(), request.getUserName(), requestResult.toString());
        return null;
    }

    public JsonResult checkResult(String taskId) {
        return null;
    }

    public JsonResult checkTask(CustomsTaxCheckRequest customsTaxCheckRequest) {
        JsonResult jsonResult = this.customsTaxService.check(customsTaxCheckRequest);
        if (jsonResult.isSuccess()) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("customs_no", customsTaxCheckRequest.getCustomsPaymentNo());
            queryMap.put("status", "0");
            List entities = this.tDxCustomsTaskMapper.selectByMap(queryMap);
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                TDxCustomsTaskEntity entity = (TDxCustomsTaskEntity)entities.stream().findFirst().get();
                JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)jsonResult.getData()));
                entity.setTaskId(jsonObject.getString("taskId"));
                entity.setNum(Integer.valueOf(entity.getNum() + 1));
                entity.setStatus(CronStatusEnum.CRONSTATUS_1.getCode());
                entity.setUpdateTime(new Date());
                this.tDxCustomsTaskMapper.updateById((Object)entity);
            }
        }
        return jsonResult;
    }

    public TDxCustomsEntity copyEntity(CustomsTaxResultResponse resultResponse) {
        TDxCustomsEntity entity = new TDxCustomsEntity();
        entity.setCustomsNo(resultResponse.getCustomsPaymentNo());
        entity.setCompanyTaxNo(resultResponse.getBuyerTaxNo());
        entity.setPaperDrewDate(resultResponse.getDateIssued());
        entity.setTaxAmount(resultResponse.getTaxAmount());
        if (Objects.nonNull(resultResponse.getEffectiveTaxAmount())) {
            entity.setEffectiveTaxAmount(new BigDecimal(resultResponse.getEffectiveTaxAmount()));
        }
        entity.setIsCheck(resultResponse.getAuthStatus());
        entity.setTaxPeriod(resultResponse.getTaxPeriod());
        if (StringUtils.isNotBlank((CharSequence)resultResponse.getCheckTime())) {
            entity.setCheckTime(DateUtils.format((long)Long.parseLong(resultResponse.getCheckTime())));
        }
        if (StringUtils.isNotBlank((CharSequence)resultResponse.getEnsureTime())) {
            entity.setSignTime(resultResponse.getEnsureTime());
        }
        entity.setCheckPurpose(resultResponse.getAuthUse());
        entity.setManageStatus(resultResponse.getManageStatus());
        entity.setUserName(resultResponse.getUserName());
        entity.setAbnormalInfo(resultResponse.getAbnormalInfo());
        return entity;
    }

    public String queryCompanyName(String taxNo) {
        String companyName = null;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"taxno", (Object)taxNo);
        List tAcOrgEntities = this.tAcOrgMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)tAcOrgEntities)) {
            companyName = ((TAcOrgEntity)tAcOrgEntities.stream().findFirst().get()).getOrgName();
        }
        log.info("\u6839\u636e\u7a0e\u53f7\u67e5\u8be2\u516c\u53f8\u540d\u79f0,\u7a0e\u53f7:{},\u67e5\u8be2\u51fa\u7684\u516c\u53f8\u540d\u79f0:{}", (Object)taxNo, companyName);
        return companyName;
    }
}

