/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.evat.domain.TDxNgsLockEntity;
import com.xforceplus.evat.enums.NgsIsLockEnum;
import com.xforceplus.evat.modules.mapper.TDxNgsLockMapper;
import com.xforceplus.evat.modules.service.TDxNgsLockService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class TDxNgsLockServiceImpl
extends ServiceImpl<TDxNgsLockMapper, TDxNgsLockEntity>
implements TDxNgsLockService {
    private static final Logger log = LoggerFactory.getLogger(TDxNgsLockServiceImpl.class);

    public void lock(String operationType) {
        try {
            this.updateIsLock(operationType, NgsIsLockEnum.LOCK.getCode());
        }
        catch (Exception e) {
            log.error("ngs\u6c47\u603b\u4e0a\u9501\u5931\u8d25!");
        }
    }

    public void unLock(String operationType) {
        try {
            this.updateIsLock(operationType, NgsIsLockEnum.UN_LOCK.getCode());
        }
        catch (Exception e) {
            log.error("ngs\u6c47\u603b\u4e0a\u9501\u5931\u8d25!");
        }
    }

    public Boolean isDo(String operationType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TDxNgsLockEntity::getOperationType, (Object)operationType);
        TDxNgsLockEntity entity = (TDxNgsLockEntity)this.getOne((Wrapper)queryWrapper);
        if (!ObjectUtils.isEmpty((Object)entity) && entity.getIsLock().equals(NgsIsLockEnum.LOCK.getCode())) {
            return false;
        }
        return true;
    }

    private void updateIsLock(String operationType, Integer isLock) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TDxNgsLockEntity::getOperationType, (Object)operationType);
        TDxNgsLockEntity entity = (TDxNgsLockEntity)this.getOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)entity)) {
            entity = new TDxNgsLockEntity();
            entity.setOperationType(operationType);
            entity.setIsLock(isLock);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            this.save((Object)entity);
        } else {
            entity.setIsLock(isLock);
            entity.setUpdateTime(new Date());
            this.updateById((Object)entity);
        }
    }
}

