/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xforceplus.evat.common.constant.enums.SourceSystemEnum;
import com.xforceplus.evat.common.domain.verify.InvoiceDetail;
import com.xforceplus.evat.common.domain.verify.InvoiceMain;
import com.xforceplus.evat.common.domain.verify.VerificationResponse;
import com.xforceplus.evat.common.utils.DateUtils;
import com.xforceplus.evat.domain.TDxRecordInvoiceDetailEntity;
import com.xforceplus.evat.domain.TDxRecordInvoiceEntity;
import com.xforceplus.evat.modules.mapper.TDxRecordInvoiceMapper;
import com.xforceplus.evat.modules.service.TDxRecordInvoiceDetailService;
import com.xforceplus.evat.modules.service.TDxRecordInvoiceService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TDxRecordInvoiceServiceImpl
implements TDxRecordInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(TDxRecordInvoiceServiceImpl.class);
    @Autowired
    private TDxRecordInvoiceDetailService tDxRecordInvoiceDetailService;
    @Autowired
    private TDxRecordInvoiceMapper tDxRecordInvoiceMapper;

    public void verifySaveOrUpdate(VerificationResponse.VerificationResult verificationResult) {
        try {
            InvoiceMain invoiceMain = verificationResult.getInvoiceMain();
            if (invoiceMain == null) {
                return;
            }
            String uuid = (String)StringUtils.defaultIfBlank((CharSequence)invoiceMain.getInvoiceCode(), (CharSequence)"") + invoiceMain.getInvoiceNo();
            TDxRecordInvoiceEntity _tDxRecordInvoiceEntity = new TDxRecordInvoiceEntity();
            _tDxRecordInvoiceEntity.setUuid(uuid);
            _tDxRecordInvoiceEntity = this.selectOne(_tDxRecordInvoiceEntity);
            List invoiceDetails = verificationResult.getInvoiceDetails();
            TDxRecordInvoiceEntity recordInvoice = new TDxRecordInvoiceEntity();
            recordInvoice.setInvoiceCode(invoiceMain.getInvoiceCode());
            recordInvoice.setInvoiceNo(invoiceMain.getInvoiceNo());
            recordInvoice.setInvoiceAmount(new BigDecimal(invoiceMain.getAmountWithoutTax()));
            recordInvoice.setDkInvoiceamount(new BigDecimal(invoiceMain.getAmountWithoutTax()));
            recordInvoice.setInvoiceDate(DateUtils.convertStringToDate((String)invoiceMain.getPaperDrewDate()));
            recordInvoice.setTotalAmount(new BigDecimal(invoiceMain.getAmountWithTax()));
            recordInvoice.setTaxAmount(new BigDecimal(invoiceMain.getTaxAmount()));
            recordInvoice.setTaxRate(new BigDecimal(((InvoiceDetail)invoiceDetails.get(0)).getTaxRate()));
            long taxRateCount = invoiceDetails.stream().map(InvoiceDetail::getTaxRate).distinct().count();
            if (taxRateCount > 1L) {
                recordInvoice.setTaxRate(null);
            }
            recordInvoice.setInvoiceType(invoiceMain.getInvoiceType());
            recordInvoice.setGfName(invoiceMain.getPurchaserName());
            recordInvoice.setGfTaxNo(invoiceMain.getPurchaserTaxNo());
            recordInvoice.setGfAddressAndPhone(invoiceMain.getPurchaserAddrTel());
            recordInvoice.setGfBankAndNo(invoiceMain.getPurchaserBankInfo());
            recordInvoice.setCheckCode(invoiceMain.getCheckCode());
            recordInvoice.setXfName(invoiceMain.getSellerName());
            recordInvoice.setXfTaxNo(invoiceMain.getSellerTaxNo());
            recordInvoice.setXfAddressAndPhone(invoiceMain.getSellerAddrTel());
            recordInvoice.setXfBankAndNo(invoiceMain.getSellerBankInfo());
            recordInvoice.setSourceSystem(Optional.ofNullable(_tDxRecordInvoiceEntity).map(TDxRecordInvoiceEntity::getSourceSystem).orElse(SourceSystemEnum.DZ_SOURCE_VERIFY.getCode()));
            recordInvoice.setGoodsListFlag(invoiceMain.getGoodsListFlag());
            recordInvoice.setMachinecode(invoiceMain.getMachineCode());
            recordInvoice.setInvoiceStatus(TDxRecordInvoiceServiceImpl.convertStatus((String)invoiceMain.getStatus(), (String)invoiceMain.getRedFlag()));
            recordInvoice.setRemark(invoiceMain.getRemark());
            recordInvoice.setDetailYesorno("1");
            recordInvoice.setUuid(Objects.toString(invoiceMain.getInvoiceCode(), "") + invoiceMain.getInvoiceNo());
            int result = this.saveOrUpdate(recordInvoice);
            if (invoiceDetails.size() > 0) {
                ArrayList<TDxRecordInvoiceDetailEntity> detailList = new ArrayList<TDxRecordInvoiceDetailEntity>();
                HashMap<String, String> columnMap = new HashMap<String, String>();
                columnMap.put("uuid", uuid);
                this.tDxRecordInvoiceDetailService.deleteByMap(columnMap);
                for (int i = 0; i < invoiceDetails.size(); ++i) {
                    InvoiceDetail invoiceDetail = (InvoiceDetail)invoiceDetails.get(i);
                    TDxRecordInvoiceDetailEntity tDxRecordInvoiceDetailEntity = new TDxRecordInvoiceDetailEntity();
                    tDxRecordInvoiceDetailEntity.setInvoiceNo(recordInvoice.getInvoiceNo());
                    tDxRecordInvoiceDetailEntity.setInvoiceCode(recordInvoice.getInvoiceCode());
                    tDxRecordInvoiceDetailEntity.setUuid(recordInvoice.getUuid());
                    tDxRecordInvoiceDetailEntity.setDetailNo(String.valueOf(i + 1));
                    tDxRecordInvoiceDetailEntity.setDetailAmount(invoiceDetail.getAmountWithoutTax());
                    tDxRecordInvoiceDetailEntity.setGoodsName(invoiceDetail.getCargoName());
                    tDxRecordInvoiceDetailEntity.setTaxAmount(invoiceDetail.getTaxAmount());
                    tDxRecordInvoiceDetailEntity.setTaxRate(invoiceDetail.getTaxRate());
                    tDxRecordInvoiceDetailEntity.setNum(invoiceDetail.getQuantity());
                    tDxRecordInvoiceDetailEntity.setUnit(invoiceDetail.getQuantityUnit());
                    tDxRecordInvoiceDetailEntity.setUnitPrice(invoiceDetail.getUnitPrice());
                    tDxRecordInvoiceDetailEntity.setModel(invoiceDetail.getItemSpec());
                    detailList.add(tDxRecordInvoiceDetailEntity);
                }
                this.tDxRecordInvoiceDetailService.saveBatch(detailList);
            }
        }
        catch (Exception e) {
            log.error("error=", (Throwable)e);
        }
    }

    public List<TDxRecordInvoiceEntity> getNgsInputInvoice(String taxPeriod, String gfTaxNo, String authStatus, String uuid, int pageNo, int pageSize) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)uuid), TDxRecordInvoiceEntity::getUuid, (Object)uuid);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)gfTaxNo), TDxRecordInvoiceEntity::getGfTaxNo, (Object)gfTaxNo);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)taxPeriod), TDxRecordInvoiceEntity::getRzhBelongDate, (Object)taxPeriod);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)authStatus), TDxRecordInvoiceEntity::getAuthStatus, (Object)authStatus);
        queryWrapper.orderByAsc(TDxRecordInvoiceEntity::getId);
        Page page = (Page)this.tDxRecordInvoiceMapper.selectPage((IPage)new Page((long)pageNo, (long)pageSize), (Wrapper)queryWrapper);
        return page.getRecords();
    }

    public int getNgsInputInvoiceCount(String taxPeriod, String gfTaxNo, String authStatus, String uuid) {
        return this.tDxRecordInvoiceMapper.getNgsInputInvoiceCount(taxPeriod, gfTaxNo, authStatus, uuid);
    }

    private static String convertStatus(String status, String redFlag) {
        if (Objects.equals(redFlag, "1") || Objects.equals(redFlag, "2")) {
            return "3";
        }
        switch (status) {
            case "1": {
                return "0";
            }
            case "0": {
                return "2";
            }
        }
        return "4";
    }

    public TDxRecordInvoiceEntity selectOne(TDxRecordInvoiceEntity tDxRecordInvoiceEntity) {
        if (tDxRecordInvoiceEntity == null) {
            return null;
        }
        return this.tDxRecordInvoiceMapper.findOne(tDxRecordInvoiceEntity);
    }

    public Integer saveOrUpdate(TDxRecordInvoiceEntity tDxRecordInvoiceEntity) {
        if (tDxRecordInvoiceEntity == null) {
            return 0;
        }
        tDxRecordInvoiceEntity.setLastUpdateDate(new Date());
        String uuid = (String)StringUtils.defaultIfBlank((CharSequence)tDxRecordInvoiceEntity.getInvoiceCode(), (CharSequence)"") + tDxRecordInvoiceEntity.getInvoiceNo();
        TDxRecordInvoiceEntity _tDxRecordInvoiceEntity = new TDxRecordInvoiceEntity();
        _tDxRecordInvoiceEntity.setUuid(uuid);
        _tDxRecordInvoiceEntity = this.selectOne(_tDxRecordInvoiceEntity);
        if (_tDxRecordInvoiceEntity == null || _tDxRecordInvoiceEntity.getId() == null) {
            tDxRecordInvoiceEntity.setCreateDate(new Date());
            return this.tDxRecordInvoiceMapper.insert((Object)tDxRecordInvoiceEntity);
        }
        tDxRecordInvoiceEntity.setId(_tDxRecordInvoiceEntity.getId());
        return this.tDxRecordInvoiceMapper.updateById((Object)tDxRecordInvoiceEntity);
    }
}

