/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.threadpool;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ThreadPoolManager {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolManager.class);
    private static final int corePoolSize = Runtime.getRuntime().availableProcessors() * 2;
    private static final int maximumPoolSize = Runtime.getRuntime().availableProcessors() * 4;
    private static final int slowDealPoolSize = Runtime.getRuntime().availableProcessors() * 3;
    private static final long keepActiveTime = 200L;
    private static final TimeUnit timeUnit = TimeUnit.SECONDS;
    private static final BlockingQueue<Runnable> workQueueL1 = new ArrayBlockingQueue(10);
    private static final BlockingQueue<Runnable> workQueueL2 = new ArrayBlockingQueue(10);
    private static ThreadPoolExecutor customExecutorL1 = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 200L, timeUnit, (BlockingQueue<Runnable>)workQueueL1, new ThreadPoolExecutor.CallerRunsPolicy());
    private static ThreadPoolExecutor customExecutorL2 = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 200L, timeUnit, (BlockingQueue<Runnable>)workQueueL2, new ThreadPoolExecutor.CallerRunsPolicy());
    private static ThreadPoolExecutor customExecutorL3 = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 200L, timeUnit, (BlockingQueue<Runnable>)workQueueL2, new ThreadPoolExecutor.CallerRunsPolicy());
    private static ExecutorService cachedExecutor = Executors.newCachedThreadPool();
    private static ExecutorService fixedExecutor = Executors.newFixedThreadPool(9);
    private static ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2);

    public static Future<Boolean> submitCustomL1(Callable<Boolean> callable) {
        if (customExecutorL1 == null) {
            customExecutorL1 = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 200L, timeUnit, (BlockingQueue<Runnable>)workQueueL1, new ThreadPoolExecutor.CallerRunsPolicy());
        }
        if (customExecutorL1.getActiveCount() >= slowDealPoolSize && workQueueL1.size() > 8) {
            logger.warn("#################################\u81ea\u5b9a\u4e49\u4e00\u7ea7\u7ebf\u7a0b\u6c60\u5fd9\u788c\uff01\uff01\uff01#################################");
            logger.warn("\u81ea\u5b9a\u4e49\u4e00\u7ea7\u7ebf\u7a0b\u6c60\u72b6\u6001\u53c2\u6570\uff1a{}", (Object)ThreadPoolManager.getCustomExecutorL1Status());
        }
        return customExecutorL1.submit(callable);
    }

    public static Future<Boolean> submitCustomL2(Callable<Boolean> callable) {
        if (customExecutorL2 == null) {
            customExecutorL2 = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 200L, timeUnit, (BlockingQueue<Runnable>)workQueueL2, new ThreadPoolExecutor.CallerRunsPolicy());
        }
        if (customExecutorL2.getActiveCount() >= slowDealPoolSize && workQueueL2.size() > 8) {
            logger.warn("#################################\u81ea\u5b9a\u4e49\u4e8c\u7ea7\u7ebf\u7a0b\u6c60\u5fd9\u788c\uff01\uff01\uff01#################################");
            logger.warn("\u81ea\u5b9a\u4e49\u4e8c\u7ea7\u7ebf\u7a0b\u6c60\u72b6\u6001\u53c2\u6570\uff1a{}", (Object)ThreadPoolManager.getCustomExecutorL2Status());
        }
        return customExecutorL2.submit(callable);
    }

    public static Future submitCustomL3(Runnable runnable) {
        if (customExecutorL3 == null) {
            customExecutorL3 = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 200L, timeUnit, (BlockingQueue<Runnable>)workQueueL1, new ThreadPoolExecutor.CallerRunsPolicy());
        }
        if (customExecutorL3.getActiveCount() >= slowDealPoolSize && workQueueL1.size() > 8) {
            logger.warn("#################################\u81ea\u5b9a\u4e49\u4e00\u7ea7\u7ebf\u7a0b\u6c60\u5fd9\u788c\uff01\uff01\uff01#################################");
            logger.warn("\u81ea\u5b9a\u4e49\u4e00\u7ea7\u7ebf\u7a0b\u6c60\u72b6\u6001\u53c2\u6570\uff1a{}", (Object)ThreadPoolManager.getCustomExecutorL3Status());
        }
        return customExecutorL3.submit(runnable);
    }

    public static Future<Boolean> submitCached(Callable<Boolean> callable) {
        if (cachedExecutor == null) {
            cachedExecutor = Executors.newCachedThreadPool();
        }
        return cachedExecutor.submit(callable);
    }

    public static Future<Boolean> submitFixed(Callable<Boolean> callable) {
        if (fixedExecutor == null) {
            fixedExecutor = Executors.newFixedThreadPool(5);
        }
        return fixedExecutor.submit(callable);
    }

    public static Future<Boolean> submitScheduled(Callable<Boolean> callable, long delay, TimeUnit unit) {
        if (scheduledExecutor == null) {
            scheduledExecutor = Executors.newScheduledThreadPool(2);
        }
        return scheduledExecutor.schedule(callable, delay, unit);
    }

    public static String getCustomExecutorL1Status() {
        return customExecutorL1.toString();
    }

    public static String getCustomExecutorL2Status() {
        return customExecutorL2.toString();
    }

    public static String getCustomExecutorL3Status() {
        return customExecutorL3.toString();
    }

    public static String getFixedExecutorStatus() {
        return fixedExecutor.toString();
    }

    public static String getCachedExecutorStatus() {
        return cachedExecutor.toString();
    }

    public static String getScheduledExecutorStatus() {
        return scheduledExecutor.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(customExecutorL1.getActiveCount());
    }
}

