/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.threadpool.callable;

import com.xforceplus.evat.domain.TDxNgsInputInvoiceEntity;
import com.xforceplus.evat.domain.TDxRecordInvoiceDetailEntity;
import com.xforceplus.evat.domain.TDxRecordInvoiceEntity;
import com.xforceplus.evat.modules.service.TDxRecordInvoiceDetailService;
import com.xforceplus.evat.modules.service.impl.TDxNgsInputInvoiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class NgsInputInvoiceThread
implements Runnable {
    private CountDownLatch countDownLatch;
    private TDxNgsInputInvoiceImpl ngsInputInvoiceService;
    private List<TDxRecordInvoiceEntity> mainList;
    @Autowired
    private TDxRecordInvoiceDetailService detailService;

    @Override
    public void run() {
        int listSize = 20;
        List subs = ListUtils.partition((List)this.mainList, (int)listSize);
        for (List sub : subs) {
            ArrayList<TDxNgsInputInvoiceEntity> ngsList = new ArrayList<TDxNgsInputInvoiceEntity>(listSize * 4);
            List uuids = sub.stream().map(TDxRecordInvoiceEntity::getUuid).collect(Collectors.toList());
            List detailEntities = this.detailService.selectListByUuid(uuids);
            Map<String, List<TDxRecordInvoiceDetailEntity>> detailsMap = detailEntities.stream().collect(Collectors.groupingBy(TDxRecordInvoiceDetailEntity::getUuid));
            Map flowTypeJv = this.ngsInputInvoiceService.getFlowTypeJv(sub);
            Map flowTypeTaxCode = this.ngsInputInvoiceService.getFlowTypeTaxCode(sub);
            for (TDxRecordInvoiceEntity tDxRecordInvoiceEntity : sub) {
                TDxRecordInvoiceDetailEntity detailQuery = new TDxRecordInvoiceDetailEntity();
                detailQuery.setUuid(tDxRecordInvoiceEntity.getUuid());
                List<TDxRecordInvoiceDetailEntity> detailList = detailsMap.get(tDxRecordInvoiceEntity.getUuid());
                if (CollectionUtils.isEmpty(detailList)) continue;
                Map<String, List<TDxRecordInvoiceDetailEntity>> taxRateMap = detailList.stream().collect(Collectors.groupingBy(TDxRecordInvoiceDetailEntity::getTaxRate));
                for (String taxRate : taxRateMap.keySet()) {
                    List<TDxRecordInvoiceDetailEntity> taxRateDetailList = taxRateMap.get(taxRate);
                    TDxNgsInputInvoiceEntity ngsInputInvoiceEntity = this.ngsInputInvoiceService.createNgsInputInvoiceEntity(tDxRecordInvoiceEntity, flowTypeJv, flowTypeTaxCode);
                    BigDecimal taxAmount = new BigDecimal(0);
                    BigDecimal amountWithTax = new BigDecimal(0);
                    BigDecimal amountWithoutTax = new BigDecimal(0);
                    for (TDxRecordInvoiceDetailEntity detailEntity : taxRateDetailList) {
                        ngsInputInvoiceEntity.setTaxAmount(this.ngsInputInvoiceService.formatBigdecimal(detailEntity.getTaxAmount()));
                        ngsInputInvoiceEntity.setTaxRate(this.ngsInputInvoiceService.formatBigdecimal(detailEntity.getTaxRate()));
                        taxAmount = taxAmount.add(this.ngsInputInvoiceService.formatBigdecimal(detailEntity.getTaxAmount()));
                        amountWithoutTax = amountWithoutTax.add(this.ngsInputInvoiceService.formatBigdecimal(detailEntity.getDetailAmount()));
                    }
                    amountWithTax = taxAmount.add(amountWithoutTax);
                    ngsInputInvoiceEntity.setTaxAmount(taxAmount);
                    ngsInputInvoiceEntity.setAmountWithTax(amountWithTax);
                    ngsInputInvoiceEntity.setAmountWithoutTax(amountWithoutTax);
                    ngsList.add(ngsInputInvoiceEntity);
                }
            }
            this.ngsInputInvoiceService.saveOrUpdateList(ngsList);
        }
        this.countDownLatch.countDown();
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public TDxNgsInputInvoiceImpl getNgsInputInvoiceService() {
        return this.ngsInputInvoiceService;
    }

    public List<TDxRecordInvoiceEntity> getMainList() {
        return this.mainList;
    }

    public TDxRecordInvoiceDetailService getDetailService() {
        return this.detailService;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public void setNgsInputInvoiceService(TDxNgsInputInvoiceImpl ngsInputInvoiceService) {
        this.ngsInputInvoiceService = ngsInputInvoiceService;
    }

    public void setMainList(List<TDxRecordInvoiceEntity> mainList) {
        this.mainList = mainList;
    }

    public void setDetailService(TDxRecordInvoiceDetailService detailService) {
        this.detailService = detailService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NgsInputInvoiceThread)) {
            return false;
        }
        NgsInputInvoiceThread other = (NgsInputInvoiceThread)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CountDownLatch this$countDownLatch = this.getCountDownLatch();
        CountDownLatch other$countDownLatch = other.getCountDownLatch();
        if (this$countDownLatch == null ? other$countDownLatch != null : !this$countDownLatch.equals(other$countDownLatch)) {
            return false;
        }
        TDxNgsInputInvoiceImpl this$ngsInputInvoiceService = this.getNgsInputInvoiceService();
        TDxNgsInputInvoiceImpl other$ngsInputInvoiceService = other.getNgsInputInvoiceService();
        if (this$ngsInputInvoiceService == null ? other$ngsInputInvoiceService != null : !this$ngsInputInvoiceService.equals(other$ngsInputInvoiceService)) {
            return false;
        }
        List this$mainList = this.getMainList();
        List other$mainList = other.getMainList();
        if (this$mainList == null ? other$mainList != null : !((Object)this$mainList).equals(other$mainList)) {
            return false;
        }
        TDxRecordInvoiceDetailService this$detailService = this.getDetailService();
        TDxRecordInvoiceDetailService other$detailService = other.getDetailService();
        return !(this$detailService == null ? other$detailService != null : !this$detailService.equals(other$detailService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NgsInputInvoiceThread;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CountDownLatch $countDownLatch = this.getCountDownLatch();
        result = result * 59 + ($countDownLatch == null ? 43 : $countDownLatch.hashCode());
        TDxNgsInputInvoiceImpl $ngsInputInvoiceService = this.getNgsInputInvoiceService();
        result = result * 59 + ($ngsInputInvoiceService == null ? 43 : $ngsInputInvoiceService.hashCode());
        List $mainList = this.getMainList();
        result = result * 59 + ($mainList == null ? 43 : ((Object)$mainList).hashCode());
        TDxRecordInvoiceDetailService $detailService = this.getDetailService();
        result = result * 59 + ($detailService == null ? 43 : $detailService.hashCode());
        return result;
    }

    public String toString() {
        return "NgsInputInvoiceThread(countDownLatch=" + this.getCountDownLatch() + ", ngsInputInvoiceService=" + this.getNgsInputInvoiceService() + ", mainList=" + this.getMainList() + ", detailService=" + this.getDetailService() + ")";
    }

    public NgsInputInvoiceThread(CountDownLatch countDownLatch, TDxNgsInputInvoiceImpl ngsInputInvoiceService, List<TDxRecordInvoiceEntity> mainList, TDxRecordInvoiceDetailService detailService) {
        this.countDownLatch = countDownLatch;
        this.ngsInputInvoiceService = ngsInputInvoiceService;
        this.mainList = mainList;
        this.detailService = detailService;
    }
}

