/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.configuration;

import com.alibaba.fastjson.JSON;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=90)
@Configuration
public class LogMdcConfig {
    private static final Logger log = LoggerFactory.getLogger(LogMdcConfig.class);

    @Pointcut(value="execution(* com.xforceplus.evat.modules.controller..*.*(..))")
    public void executionService() {
    }

    @Before(value="executionService()")
    public void doBefore(JoinPoint joinPoint) {
        MDC.put((String)"traceId", (String)(System.currentTimeMillis() + "" + ThreadLocalRandom.current().nextInt(0, 10000)));
        Object[] args = joinPoint.getArgs();
        if (Objects.isNull(args)) {
            return;
        }
        List<Object> argsList = Arrays.asList(args);
        List collect = argsList.stream().filter(o -> !(o instanceof HttpServletResponse) && !(o instanceof HttpServletRequest)).collect(Collectors.toList());
        log.info("{}.{} , param: {}", new Object[]{joinPoint.getSignature().getDeclaringType().getSimpleName(), joinPoint.getSignature().getName(), JacksonUtil.getInstance().toJson(collect)});
    }

    @AfterReturning(pointcut="executionService()", returning="returnValue")
    public void doAfterReturning(JoinPoint joinPoint, Object returnValue) {
        returnValue = JSON.toJSONString((Object)returnValue);
        returnValue = StringUtils.substring((String)(returnValue + ""), (int)0, (int)1000);
        log.info("{}.{} , response: {}", new Object[]{joinPoint.getSignature().getDeclaringType().getSimpleName(), joinPoint.getSignature().getName(), returnValue});
        MDC.clear();
    }
}

