/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.configuration;

import com.xforceplus.apollo.client.netty.IMessageListener;
import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.evat.common.constant.consist.JanusConfig;
import com.xforceplus.evat.common.modules.tcp.GlobalReceiveMsgHandle;
import com.xforceplus.evat.common.modules.tcp.ReceiveMsgListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ReceiveMsgConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ReceiveMsgConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={IMessageListener.class})
    public IMessageListener sealedMessageListener(GlobalReceiveMsgHandle globalReceiveMsgHandle) {
        return new ReceiveMsgListener(globalReceiveMsgHandle);
    }

    @Bean
    @ConditionalOnProperty(prefix="xforceplus.janus.tcp", name={"open"}, havingValue="true", matchIfMissing=true)
    public MCFactory mcFactory(ReceiveMsgListener receiveMsgListener, JanusConfig janusConfig) {
        if (janusConfig == null || janusConfig.getTcp() == null) {
            log.warn("======= \u672a\u83b7\u53d6\u5230janusConfig\u914d\u7f6e\u4fe1\u606f =======");
            return null;
        }
        if (!janusConfig.getTcp().isOpen()) {
            log.warn("======= \u96c6\u6210\u5e73\u53f0\u5ba2\u6237\u7aef\uff1a\u672a\u542f\u52a8 =======");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)janusConfig.getTcp().getCustomerNo()) || StringUtils.isBlank((CharSequence)janusConfig.getTcp().getHost())) {
            log.warn("======= \u672a\u83b7\u53d6\u5230janusConfig TCP \u914d\u7f6e\u4fe1\u606f =======");
            return null;
        }
        MCFactory mcFactory = MCFactory.getInstance((String)janusConfig.getTcp().getCustomerNo(), (String)janusConfig.getTcp().getHost(), (int)janusConfig.getTcp().getPort());
        mcFactory.registerListener((IMessageListener)receiveMsgListener);
        log.info("======= \u96c6\u6210\u5e73\u53f0\u5ba2\u6237\u7aef\uff1a\u5f00\u542f =======");
        log.info("======= \u96c6\u6210\u5e73\u53f0\u5ba2\u6237\u7aef customerNo\uff1a{} =======", (Object)janusConfig.getTcp().getCustomerNo());
        return mcFactory;
    }
}

