/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.controller;

import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.customs.CustomsTaxCheckRequest;
import com.xforceplus.evat.common.domain.customs.CustomsTaxResultResponse;
import com.xforceplus.evat.common.modules.taxware.CustomsTaxService;
import com.xforceplus.evat.common.utils.CommonUtils;
import com.xforceplus.evat.modules.service.TDxCustomsService;
import com.xforceplus.evat.modules.service.TDxCustomsTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/janus/customstax"})
public class CustomsTaxController {
    private static final Logger log = LoggerFactory.getLogger(CustomsTaxController.class);
    @Autowired
    private CustomsTaxService customsTaxService;
    @Autowired
    private TDxCustomsService tDxCustomsService;
    @Autowired
    private TDxCustomsTaskService tDxCustomsTaskService;

    @PostMapping(value={"/check"})
    public JsonResult check(@RequestBody CustomsTaxCheckRequest customsTaxCheckRequest) {
        CustomsTaxCheckRequest newCustomsTaxCheckRequest = new CustomsTaxCheckRequest();
        BeanUtils.copyProperties((Object)customsTaxCheckRequest, (Object)newCustomsTaxCheckRequest);
        log.info("check newCustomsTaxCheckRequest:{}", (Object)newCustomsTaxCheckRequest);
        JsonResult jsonResult = this.customsTaxService.check(newCustomsTaxCheckRequest);
        return jsonResult;
    }

    @GetMapping(value={"/checkResult/{taskId}"})
    public JsonResult checkResult(@PathVariable String taskId) {
        String newTaskId = CommonUtils.strSecurityFilter((String)taskId);
        log.info("checkResult newTaskId:{}", (Object)newTaskId);
        JsonResult jsonResult = this.customsTaxService.checkResult(newTaskId);
        return jsonResult;
    }

    @PostMapping(value={"/checkTask"})
    public JsonResult checkTask(@RequestBody CustomsTaxCheckRequest customsTaxCheckRequest) {
        CustomsTaxCheckRequest newCustomsTaxCheckRequest = new CustomsTaxCheckRequest();
        BeanUtils.copyProperties((Object)customsTaxCheckRequest, (Object)newCustomsTaxCheckRequest);
        log.info("check newCustomsTaxCheckRequest:{}", (Object)newCustomsTaxCheckRequest);
        return this.tDxCustomsService.checkTask(newCustomsTaxCheckRequest);
    }

    @PostMapping(value={"/testSave"})
    public JsonResult testSave(@RequestBody CustomsTaxResultResponse resultResponse) {
        CustomsTaxResultResponse newCustomsTaxResultResponse = new CustomsTaxResultResponse();
        BeanUtils.copyProperties((Object)resultResponse, (Object)newCustomsTaxResultResponse);
        log.info("testSave newCustomsTaxResultResponse:{}", (Object)newCustomsTaxResultResponse);
        return JsonResult.data((Object)this.tDxCustomsService.saveCustoms(newCustomsTaxResultResponse));
    }

    @PostMapping(value={"/testTaskSave"})
    public JsonResult testTaskSave(@RequestBody String params) {
        return JsonResult.data((Object)this.tDxCustomsTaskService.saveTask(params));
    }

    @PostMapping(value={"/checkRequest"})
    public JsonResult checkRequest(@RequestBody String params) {
        return JsonResult.data((Object)this.tDxCustomsTaskService.checkRequest(params));
    }

    @PostMapping(value={"/makeCustomsTask"})
    public JsonResult makeCustomsTask() {
        this.tDxCustomsTaskService.makeCustomsTask();
        return JsonResult.ok((String)"\u624b\u52a8\u89e6\u53d1\u5b9a\u65f6\u52fe\u9009\u8bf7\u6c42\u6210\u529f");
    }

    @PostMapping(value={"/makeCustomsTaskResult"})
    public JsonResult makeCustomsTaskResult() {
        this.tDxCustomsTaskService.makeCustomsTaskResult();
        return JsonResult.ok((String)"\u624b\u52a8\u89e6\u53d1\u5b9a\u65f6\u52fe\u9009\u7ed3\u679c\u83b7\u53d6\u6210\u529f");
    }
}

