/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.controller;

import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.file.FileStoreRequest;
import com.xforceplus.evat.common.domain.file.FileStoreResponse;
import com.xforceplus.evat.modules.service.FileStoreService;
import io.vavr.control.Either;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/file/store"})
public class FileStoreController {
    private static final Logger log = LoggerFactory.getLogger(FileStoreController.class);
    @Autowired
    private FileStoreService fileStoreService;

    @RequestMapping(value={"/upload"})
    public JsonResult<Object> uploadFile(@RequestBody FileStoreRequest fileStoreRequest) throws Exception {
        Either either = this.fileStoreService.upload(fileStoreRequest);
        if (either.isLeft()) {
            return JsonResult.error((String)((String)either.getLeft()));
        }
        return JsonResult.data((Object)either.get());
    }

    @RequestMapping(value={"/upload/V2"})
    public JsonResult<FileStoreResponse> uploadFile_v2(@RequestBody FileStoreRequest fileStoreRequest) throws Exception {
        return this.fileStoreService.upload_V2(fileStoreRequest);
    }

    @RequestMapping(value={"/download/{id}"})
    public JsonResult<FileStoreResponse> download(@PathVariable(value="id") String id) throws Exception {
        log.info("download id:{}", (Object)id);
        Either either = this.fileStoreService.downFile(id);
        if (either.isLeft()) {
            return JsonResult.error((String)((String)either.getLeft()));
        }
        return JsonResult.data((Object)either.get());
    }

    @RequestMapping(value={"/download/file/{id}"})
    public void downloadFile(HttpServletResponse response, @PathVariable(value="id") String id) throws Exception {
        log.info("downloadFile id:{}", (Object)id);
        Either either = this.fileStoreService.downFile(id);
        if (either.isLeft()) {
            throw new Exception((String)either.getLeft());
        }
        FileStoreResponse fileStoreResponse = (FileStoreResponse)either.get();
        response.reset();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", "attachment;filename=file_" + fileStoreResponse.getFileName());
        response.getOutputStream().write(Base64.decodeBase64((String)fileStoreResponse.getFileEncode()));
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    @RequestMapping(value={"/remove/{id}"})
    public JsonResult<String> remove(String id) throws Exception {
        log.info("remove id:{}", (Object)id);
        return this.fileStoreService.remove(id);
    }
}

