/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xforceplus.evat.common.constant.enums.SystemOrigEnum;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.ngs.NgdInputInvoiceQuery;
import com.xforceplus.evat.common.domain.ngs.NgsResult;
import com.xforceplus.evat.common.domain.ngs.TDxNgsInputInvoiceEntityDto;
import com.xforceplus.evat.common.entity.TDxNgsInputInvoiceEntity;
import com.xforceplus.evat.enums.NgsLockOperationTypeEnum;
import com.xforceplus.evat.modules.service.TDxNgsInputInvoiceService;
import com.xforceplus.evat.modules.service.TDxNgsLockService;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ngsInputInvoice"})
public class NgsInputInvoiceController {
    private static final Logger log = LoggerFactory.getLogger(NgsInputInvoiceController.class);
    @Autowired
    private TDxNgsInputInvoiceService ngsInputInvoiceService;
    @Autowired
    private TDxNgsLockService lockService;

    @PostMapping(value={"/list"})
    public JsonResult list(@RequestBody NgdInputInvoiceQuery vo) {
        log.info("\u67e5\u8be2\u751f\u6210\u540e\u7684NGS\u8ba4\u8bc1\u53d1\u7968\u8ba4\u8bc1\u6c47\u603b\u6570\u636e\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)vo));
        if (StringUtils.isEmpty((CharSequence)vo.getSystemOrig())) {
            return JsonResult.error((String)"\u6765\u6e90\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.equals((CharSequence)vo.getSystemOrig(), (CharSequence)SystemOrigEnum.WALMART_NGS.getSystemOrig())) {
            return JsonResult.error((String)"\u6765\u6e90\u7cfb\u7edf\u9519\u8bef!");
        }
        if (!StringUtils.isNotEmpty((CharSequence)vo.getGfTaxNo()) && !StringUtils.isNotEmpty((CharSequence)vo.getTaxPeriod())) {
            return JsonResult.error((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6216\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            Page paged = this.ngsInputInvoiceService.paged(vo);
            NgsResult ngsResult = new NgsResult();
            ArrayList<TDxNgsInputInvoiceEntityDto> response = new ArrayList<TDxNgsInputInvoiceEntityDto>();
            if (!CollectionUtils.isEmpty((Collection)paged.getRecords())) {
                for (TDxNgsInputInvoiceEntity customsSummonsEntity : paged.getRecords()) {
                    TDxNgsInputInvoiceEntityDto dto = new TDxNgsInputInvoiceEntityDto();
                    BeanUtil.copyProperties((Object)customsSummonsEntity, (Object)dto, (String[])new String[0]);
                    response.add(dto);
                }
            }
            ngsResult.setPageNo(vo.getPageNo());
            ngsResult.setPageSize(vo.getPageSize());
            ngsResult.setTotal(Long.valueOf(paged.getTotal()));
            ngsResult.setResult(response);
            return JsonResult.data((Object)ngsResult);
        }
        catch (Exception e) {
            log.error("NGS\u8fdb\u9879\u8ba4\u8bc1\u53d1\u7968\u83b7\u53d6\u5931\u8d25\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)vo), (Object)e);
            return null;
        }
    }

    @PostMapping(value={"/trigger"})
    public JsonResult triggerSaveNgsInputInvoice(@RequestBody NgdInputInvoiceQuery vo) {
        log.info("\u89e6\u53d1NGS\u8fdb\u9879\u8ba4\u8bc1\u53d1\u7968\u6570\u636e\u6c47\u603b\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)vo));
        if (!StringUtils.isNotEmpty((CharSequence)vo.getGfTaxNo()) && !StringUtils.isNotEmpty((CharSequence)vo.getTaxPeriod())) {
            return JsonResult.error((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6216\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            Boolean isDo = this.lockService.isDo(NgsLockOperationTypeEnum.NGS_INPUT_INVOICE.getCode());
            if (isDo.booleanValue()) {
                this.ngsInputInvoiceService.saveNgsInputInvoice(vo.getTaxPeriod(), vo.getGfTaxNo(), "4", null);
                return JsonResult.ok();
            }
            return JsonResult.error((String)"NGS\u8fdb\u9879\u8ba4\u8bc1\u53d1\u7968\u6c47\u603b\u6570\u636e\u6b63\u5728\u751f\u6210, \u8bf7\u52ff\u91cd\u590d\u70b9\u51fb!");
        }
        catch (Exception e) {
            log.error("\u89e6\u53d1NGS\u8fdb\u9879\u8ba4\u8bc1\u53d1\u7968\u6570\u636e\u6c47\u603b\u5931\u8d25:", (Throwable)e);
            return JsonResult.error((String)e.getMessage());
        }
    }
}

