/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.controller;

import com.alibaba.fastjson.JSON;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.verify.AnalysisXmlRequest;
import com.xforceplus.evat.common.domain.verify.AnalysisXmlResult;
import com.xforceplus.evat.common.domain.verify.VerificationRequest;
import com.xforceplus.evat.common.domain.verify.VerificationResponse;
import com.xforceplus.evat.common.modules.verify.XmlService;
import com.xforceplus.evat.modules.service.FileStoreService;
import com.xforceplus.evat.modules.service.InvoiceVerifyService;
import com.xforceplus.evat.modules.service.TDxRecordInvoiceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/janus/xml"})
public class XmlController {
    private static final Logger log = LoggerFactory.getLogger(XmlController.class);
    @Autowired
    private XmlService xmlService;
    @Autowired
    private InvoiceVerifyService invoiceVerifyService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private TDxRecordInvoiceService tDxRecordInvoiceService;

    @PostMapping
    public JsonResult analysisXml(@RequestBody AnalysisXmlRequest analysisXmlRequest) {
        AnalysisXmlRequest newAnalysisXmlRequest = new AnalysisXmlRequest();
        BeanUtils.copyProperties((Object)analysisXmlRequest, (Object)newAnalysisXmlRequest);
        log.info("analysisXml newAnalysisXmlRequest:{}", (Object)JSON.toJSONString((Object)newAnalysisXmlRequest));
        JsonResult jsonResult = this.xmlService.analysisXml(newAnalysisXmlRequest);
        if (jsonResult.isFail()) {
            return jsonResult;
        }
        return jsonResult;
    }

    @PostMapping(value={"/verify"})
    public JsonResult analysisXmlSync(@RequestBody AnalysisXmlRequest analysisXmlRequest) {
        AnalysisXmlRequest newAnalysisXmlRequest = new AnalysisXmlRequest();
        BeanUtils.copyProperties((Object)analysisXmlRequest, (Object)newAnalysisXmlRequest);
        log.info("analysisXmlSync newAnalysisXmlRequest:{}", (Object)JSON.toJSONString((Object)newAnalysisXmlRequest));
        JsonResult jsonResult = this.xmlService.analysisXml(newAnalysisXmlRequest);
        if (jsonResult.isFail()) {
            return jsonResult;
        }
        AnalysisXmlResult analysisXmlResult = (AnalysisXmlResult)jsonResult.getData();
        AnalysisXmlResult.InvoiceMainDTO invoiceMain = analysisXmlResult.getInvoiceMain();
        VerificationRequest verificationRequest = new VerificationRequest();
        verificationRequest.setInvoiceNo(invoiceMain.getInvoiceNo());
        verificationRequest.setPaperDrewDate(invoiceMain.getPaperDrewDate());
        verificationRequest.setAmountWithTax(invoiceMain.getAmountWithTax());
        verificationRequest.setAmount(invoiceMain.getAmountWithoutTax());
        verificationRequest.setSystemOrig(newAnalysisXmlRequest.getSystemOrig());
        JsonResult verifyJsonResult = this.invoiceVerifyService.invoiceVerifySync(verificationRequest);
        if (verifyJsonResult.isFail()) {
            return verifyJsonResult;
        }
        VerificationResponse.VerificationResult verificationResult = (VerificationResponse.VerificationResult)verifyJsonResult.getData();
        this.fileStoreService.analysisXmlStore(verificationResult, newAnalysisXmlRequest);
        return verifyJsonResult;
    }
}

