/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.SealedRecMessage;
import com.xforceplus.evat.common.constant.consist.XReceiveMsgType;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.customs.CustomsTaxResultResponse;
import com.xforceplus.evat.common.modules.tcp.BaseReceiveMsgServiceHandle;
import com.xforceplus.evat.modules.service.TDxCustomsService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@XReceiveMsgType(value="standard-customs-payment-sync-event")
public class CustomsTaxListener
extends BaseReceiveMsgServiceHandle {
    private static final Logger log = LoggerFactory.getLogger(CustomsTaxListener.class);
    @Autowired
    TDxCustomsService tDxCustomsService;

    public JsonResult process(SealedRecMessage sealedRecMessage) {
        Map othersMap = sealedRecMessage.getHeader().getOthers();
        if (othersMap == null || othersMap.size() < 1) {
            log.info("others empty . others={}", (Object)JacksonUtil.getInstance().toJson((Object)othersMap));
            return JsonResult.error((String)"others empty");
        }
        String object = sealedRecMessage.getPayload().getObj().toString();
        log.info("===> receive tcp customsPayment message . message={}", (Object)JacksonUtil.getInstance().toJson((Object)object));
        CustomsTaxResultResponse resultResponse = (CustomsTaxResultResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)object), CustomsTaxResultResponse.class);
        log.info("={}", (Object)JSON.toJSONString((Object)resultResponse));
        this.tDxCustomsService.saveCustoms(resultResponse);
        return JsonResult.ok((String)"");
    }
}

