/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.evat.common.constant.consist.SealedRecMessage;
import com.xforceplus.evat.common.constant.consist.XReceiveMsgType;
import com.xforceplus.evat.common.constant.enums.SystemOrigEnum;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.verify.VerificationResponse;
import com.xforceplus.evat.common.modules.tcp.BaseReceiveMsgServiceHandle;
import com.xforceplus.evat.common.modules.verify.VerifyService;
import com.xforceplus.evat.common.utils.RedisUtils;
import com.xforceplus.evat.modules.service.InvoiceVerifyService;
import com.xforceplus.evat.modules.service.TDxRecordInvoiceService;
import com.xforceplus.evat.modules.service.impl.BMSVerifyResultHandler;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@XReceiveMsgType(value="invoiceVerifyUploadResult")
public class VerifyResultListener
extends BaseReceiveMsgServiceHandle {
    private static final Logger log = LoggerFactory.getLogger(VerifyResultListener.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private VerifyService verifyService;
    @Autowired
    private InvoiceVerifyService invoiceVerifyService;
    @Autowired
    private TDxRecordInvoiceService tDxRecordInvoiceService;
    @Autowired
    BMSVerifyResultHandler bmsVerifyResultHandler;

    public JsonResult process(SealedRecMessage sealedRecMessage) {
        Map othersMap = sealedRecMessage.getHeader().getOthers();
        if (othersMap == null || othersMap.size() < 1) {
            log.info("others empty . others={}", (Object)JacksonUtil.getInstance().toJson((Object)othersMap));
            return JsonResult.error((String)"others empty");
        }
        log.info("invoiceVerifyUploadResult businessNo={},payLoadId={},serialNo={}", new Object[]{othersMap.get("businessNo"), othersMap.get("payLoadId"), othersMap.get("serialNo")});
        String systemOrig = (String)othersMap.get("customerNo");
        String taskId = (String)othersMap.get("taskId");
        String object = sealedRecMessage.getPayload().getObj().toString();
        VerificationResponse verificationResponse = (VerificationResponse)JSON.parseObject((String)object, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        String key = "hub_verify_result::" + taskId;
        this.redisUtils.set(key, (Object)verificationResponse, 10L);
        VerificationResponse.VerificationResult verificationResult = (VerificationResponse.VerificationResult)verificationResponse.getResult();
        if (verificationResponse.isOK()) {
            this.verifyService.invoiceVerifyHandle(verificationResult);
            this.tDxRecordInvoiceService.verifySaveOrUpdate(verificationResult);
        }
        if (SystemOrigEnum.WALMART_BMS.getSystemOrig().equalsIgnoreCase(systemOrig)) {
            this.bmsVerifyResultHandler.execute(sealedRecMessage);
        }
        return JsonResult.ok((String)"");
    }
}

