/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicates;
import com.xforceplus.evat.common.domain.JsonResult;
import com.xforceplus.evat.common.domain.verify.InvoiceDetail;
import com.xforceplus.evat.common.domain.verify.InvoiceMain;
import com.xforceplus.evat.common.domain.verify.VerificationRequest;
import com.xforceplus.evat.common.domain.verify.VerificationResponse;
import com.xforceplus.evat.common.entity.TInvoiceTaxMappingEntity;
import com.xforceplus.evat.common.modules.verify.VerifyService;
import com.xforceplus.evat.common.utils.RedisUtils;
import com.xforceplus.evat.modules.service.InvoiceVerifyService;
import com.xforceplus.evat.modules.service.TInvoiceTaxMappingService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceVerifyServiceImpl
implements InvoiceVerifyService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceVerifyServiceImpl.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private VerifyService verifyService;
    @Autowired
    private TInvoiceTaxMappingService invoiceTaxMappingService;
    Retryer<Boolean> retryer = RetryerBuilder.newBuilder().retryIfException().retryIfRuntimeException().retryIfExceptionOfType(Exception.class).retryIfException(Predicates.equalTo((Object)new Exception())).retryIfResult(Predicates.equalTo((Object)false)).withWaitStrategy(WaitStrategies.randomWait((long)3L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)60L, (TimeUnit)TimeUnit.SECONDS)).build();

    public JsonResult invoiceVerifySync(VerificationRequest verificationRequest) {
        JsonResult jsonResult = JsonResult.error();
        try {
            List goodsTaxNos;
            List invoiceTaxMappingList;
            jsonResult = this.verifyService.invoiceVerify(verificationRequest);
            if (jsonResult.isFail()) {
                return jsonResult;
            }
            String taskId = (String)jsonResult.getData();
            String key = "hub_verify_result::" + taskId;
            JsonResult finalJsonResult = JsonResult.error((String)"\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c\u5931\u8d25\u3002");
            Callable<Boolean> callable = () -> {
                try {
                    boolean isExists = this.redisUtils.hasKey(key);
                    log.debug("\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c,key={},exists={}", (Object)key, (Object)isExists);
                    if (!isExists) {
                        return false;
                    }
                    VerificationResponse verificationResponse = (VerificationResponse)this.redisUtils.get(key);
                    finalJsonResult.setData((Object)verificationResponse);
                    finalJsonResult.setCode("0");
                    log.info("={}", (Object)JSON.toJSONString((Object)verificationResponse));
                    return true;
                }
                catch (Exception e) {
                    log.error("error=", (Throwable)e);
                    finalJsonResult.setMessage(e.getMessage());
                    return false;
                }
            };
            this.retryer.call(callable);
            if (finalJsonResult.isFail()) {
                return finalJsonResult;
            }
            VerificationResponse verificationResponse = (VerificationResponse)finalJsonResult.getData();
            if (!verificationResponse.isOK()) {
                return JsonResult.error((String)verificationResponse.getCode(), (String)verificationResponse.getMessage());
            }
            VerificationResponse.VerificationResult verificationResult = (VerificationResponse.VerificationResult)((VerificationResponse)finalJsonResult.getData()).getResult();
            InvoiceMain invoiceMain = verificationResult.getInvoiceMain();
            List invoiceDetails = verificationResult.getInvoiceDetails();
            if (!CollectionUtils.isEmpty((Collection)invoiceDetails) && !CollectionUtils.isEmpty((Collection)(invoiceTaxMappingList = this.invoiceTaxMappingService.list((Wrapper)new LambdaQueryWrapper().in(TInvoiceTaxMappingEntity::getGoodsTaxNo, goodsTaxNos = invoiceDetails.stream().map(InvoiceDetail::getGoodsTaxNo).distinct().collect(Collectors.toList()))))) && StringUtils.isEmpty((CharSequence)invoiceMain.getRemark())) {
                log.info("\u7279\u6b8a\u884c\u4e1a\u53d1\u7968\u5907\u6ce8\u680f\u4e0d\u80fd\u4e3a\u7a7a{},{}", (Object)invoiceMain.getInvoiceNo(), (Object)invoiceMain.getInvoiceCode());
                return JsonResult.error((String)"1", (String)"\u7279\u6b8a\u884c\u4e1a\u53d1\u7968\u5907\u6ce8\u680f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.verifyService.invoiceVerifyHandle(verificationResult);
            jsonResult.setData((Object)verificationResult);
            jsonResult.setCode("0");
        }
        catch (RetryException e) {
            jsonResult.setMessage("\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
            log.error("error={}", (Object)e.getMessage());
        }
        catch (Exception e) {
            jsonResult.setMessage("\u53d1\u8d77\u9a8c\u771f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
            log.error("error={}", (Object)e.getMessage());
        }
        return jsonResult;
    }
}

