/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.evat.modules.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.evat.common.domain.ngs.CostDeptIdJv;
import com.xforceplus.evat.common.domain.ngs.NgdInputInvoiceQuery;
import com.xforceplus.evat.common.entity.TDxNgsInputInvoiceEntity;
import com.xforceplus.evat.common.utils.DateUtils;
import com.xforceplus.evat.domain.OptionEntity;
import com.xforceplus.evat.domain.TDxRecordInvoiceEntity;
import com.xforceplus.evat.domain.TXfNoneBusinessUploadDetailEntity;
import com.xforceplus.evat.enums.NgsLockOperationTypeEnum;
import com.xforceplus.evat.modules.mapper.TDxNgsInputInvoiceMapper;
import com.xforceplus.evat.modules.service.TDxNgsInputInvoiceService;
import com.xforceplus.evat.modules.service.TDxNgsLockService;
import com.xforceplus.evat.modules.service.TDxRecordInvoiceDetailService;
import com.xforceplus.evat.modules.service.TDxRecordInvoiceService;
import com.xforceplus.evat.modules.threadpool.ThreadPoolManager;
import com.xforceplus.evat.modules.threadpool.callable.NgsInputInvoiceThread;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TDxNgsInputInvoiceImpl
extends ServiceImpl<TDxNgsInputInvoiceMapper, TDxNgsInputInvoiceEntity>
implements TDxNgsInputInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(TDxNgsInputInvoiceImpl.class);
    @Autowired
    private TDxRecordInvoiceService mainService;
    @Autowired
    private TDxRecordInvoiceDetailService detailService;
    @Autowired
    private TDxNgsLockService lockService;
    @Autowired
    private TDxNgsInputInvoiceMapper ngsMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNgsInputInvoice(String taxPeriod, String gfTaxNo, String authStatus, String uuid) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        this.lockService.lock(NgsLockOperationTypeEnum.NGS_INPUT_INVOICE.getCode());
        try {
            int invoiceSize = this.mainService.getNgsInputInvoiceCount(taxPeriod, gfTaxNo, authStatus, uuid);
            int pageSize = 1000;
            int threadSize = 10;
            int cycleNumber = (invoiceSize + (pageSize - 1)) / pageSize;
            CountDownLatch latch = new CountDownLatch(cycleNumber);
            for (int pageNo = 1; pageNo <= cycleNumber; ++pageNo) {
                List mainList = this.mainService.getNgsInputInvoice(taxPeriod, gfTaxNo, authStatus, uuid, pageNo, pageSize);
                List subs = ListUtils.partition((List)mainList, (int)threadSize);
                for (List sub : subs) {
                    ThreadPoolManager.submitCustomL3((Runnable)new NgsInputInvoiceThread(latch, this, sub, this.detailService));
                }
                log.info("pageNo:{}", (Object)pageNo);
                latch.await();
            }
            this.lockService.unLock(NgsLockOperationTypeEnum.NGS_INPUT_INVOICE.getCode());
        }
        catch (Exception e) {
            log.error("NGS\u8fdb\u9879\u8ba4\u8bc1\u53d1\u7968\u6c47\u603b\u751f\u6210\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            this.lockService.unLock(NgsLockOperationTypeEnum.NGS_INPUT_INVOICE.getCode());
        }
        log.info("NGS\u8fdb\u9879\u8ba4\u8bc1\u53d1\u7968\u6c47\u603b\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    public Map<String, Map<String, String>> getFlowTypeTaxCode(List<TDxRecordInvoiceEntity> sub) {
        List values = sub.stream().map(entity -> {
            if (StringUtils.equals((CharSequence)entity.getFlowType(), (CharSequence)"1") && entity.getTaxRate() != null && entity.getInvoiceType() != null) {
                return entity.getInvoiceType() + "_" + entity.getTaxRate().setScale(0, 0).toString();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        HashMap<String, Map<String, String>> flowTypeTaxCodeMap = new HashMap<String, Map<String, String>>();
        if (!CollectionUtils.isEmpty(values)) {
            List invTypeTaxCode = this.ngsMapper.queryHostTaxRates(values);
            Map<String, String> flowType1Map = invTypeTaxCode.stream().filter(entity -> Objects.nonNull(entity.getLabel())).collect(Collectors.toMap(OptionEntity::getValue, OptionEntity::getLabel, (existingValue, newValue) -> existingValue));
            flowTypeTaxCodeMap.put("1", flowType1Map);
            return flowTypeTaxCodeMap;
        }
        return flowTypeTaxCodeMap;
    }

    public Map<String, String> getFlowTypeJv(List<TDxRecordInvoiceEntity> sub) {
        List costDeptIds = sub.stream().map(entity -> {
            if (StringUtils.equals((CharSequence)entity.getFlowType(), (CharSequence)"2")) {
                return entity.getCostDeptId();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(costDeptIds)) {
            List costDeptIdJvs = this.ngsMapper.selectCostDeptToJv(costDeptIds);
            Map<String, String> costDeptIdJvsMap = costDeptIdJvs.stream().filter(entity -> Objects.nonNull(entity.getJvCode())).collect(Collectors.toMap(CostDeptIdJv::getCostDeptId, CostDeptIdJv::getJvCode, (existingValue, newValue) -> existingValue));
            return costDeptIdJvsMap;
        }
        return new HashMap<String, String>();
    }

    public void saveOrUpdateList(List<TDxNgsInputInvoiceEntity> ngsList) {
        List uuids = ngsList.stream().map(TDxNgsInputInvoiceEntity::getUuid).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(uuids)) {
            this.ngsMapper.deleteByNgsEntity(uuids);
        }
        if (!CollectionUtils.isEmpty(uuids)) {
            this.ngsMapper.insertAll(ngsList);
        }
    }

    public Page<TDxNgsInputInvoiceEntity> paged(NgdInputInvoiceQuery vo) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)vo.getTaxPeriod()), TDxNgsInputInvoiceEntity::getTaxPeriod, (Object)vo.getTaxPeriod());
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)vo.getGfTaxNo()), TDxNgsInputInvoiceEntity::getGfTaxNo, (Object)vo.getGfTaxNo());
        queryWrapper.gt(!ObjectUtils.isEmpty((Object)vo.getId()), TDxNgsInputInvoiceEntity::getId, (Object)vo.getId());
        Page pageRsult = (Page)this.page((IPage)new Page((long)vo.getPageNo().intValue(), (long)vo.getPageSize().intValue()), (Wrapper)queryWrapper);
        return pageRsult;
    }

    public TDxNgsInputInvoiceEntity createNgsInputInvoiceEntity(TDxRecordInvoiceEntity mainEntity, Map<String, String> flowTypeJv, Map<String, Map<String, String>> flowTypeTaxCode) {
        TDxNgsInputInvoiceEntity tdxngsInputInvoiceEntity = new TDxNgsInputInvoiceEntity();
        tdxngsInputInvoiceEntity.setTaxPeriod(mainEntity.getRzhBelongDate());
        tdxngsInputInvoiceEntity.setCompanyCode(mainEntity.getCompanyCode());
        tdxngsInputInvoiceEntity.setJvCode(mainEntity.getJvcode());
        if (StringUtils.equals((CharSequence)mainEntity.getFlowType(), (CharSequence)"2") && StringUtils.isNotBlank((CharSequence)mainEntity.getCostDeptId())) {
            tdxngsInputInvoiceEntity.setJvCode(flowTypeJv.get(mainEntity.getCostDeptId()));
        }
        tdxngsInputInvoiceEntity.setInvoiceCode(mainEntity.getInvoiceCode());
        tdxngsInputInvoiceEntity.setInvoiceNo(mainEntity.getInvoiceNo());
        tdxngsInputInvoiceEntity.setScanTime(mainEntity.getQsDate());
        tdxngsInputInvoiceEntity.setScanUser(null);
        tdxngsInputInvoiceEntity.setVenderid(mainEntity.getVenderid());
        tdxngsInputInvoiceEntity.setVendername(mainEntity.getVendername());
        tdxngsInputInvoiceEntity.setCostCenter(mainEntity.getCostDeptId());
        if (StringUtils.equals((CharSequence)mainEntity.getFlowType(), (CharSequence)"1") && mainEntity.getTaxRate() != null && mainEntity.getInvoiceType() != null) {
            tdxngsInputInvoiceEntity.setTaxCode(flowTypeTaxCode.get("1").get(mainEntity.getInvoiceType() + "_" + mainEntity.getTaxRate().setScale(0, 0).toString()));
        } else {
            tdxngsInputInvoiceEntity.setTaxCode(this.formatTaxCode(mainEntity));
        }
        tdxngsInputInvoiceEntity.setVoucherNo(mainEntity.getCertificateNo());
        tdxngsInputInvoiceEntity.setPaperDrewDate(DateUtils.format((Date)mainEntity.getInvoiceDate(), (String)"yyyyMMdd"));
        if (!StringUtils.equals((CharSequence)String.valueOf(mainEntity.getExchangeStatus()), (CharSequence)"3")) {
            tdxngsInputInvoiceEntity.setNewInvoiceNo(mainEntity.getInvoiceNo());
        } else {
            tdxngsInputInvoiceEntity.setNewInvoiceNo(this.ngsMapper.queryNewinvoiceNo(mainEntity.getInvoiceNo(), mainEntity.getInvoiceCode()));
        }
        tdxngsInputInvoiceEntity.setRemark(mainEntity.getRemark());
        Date rzhDate = mainEntity.getRzhDate();
        Date invoiceDate = mainEntity.getInvoiceDate();
        tdxngsInputInvoiceEntity.setInvoiceAge(String.valueOf(DateUtils.getDays((Date)rzhDate, (Date)invoiceDate)));
        tdxngsInputInvoiceEntity.setBusinessType(this.formatServiceType(mainEntity));
        tdxngsInputInvoiceEntity.setScanUser(null);
        tdxngsInputInvoiceEntity.setIsImmovables("\u5426");
        tdxngsInputInvoiceEntity.setLargeCategory(mainEntity.getFlowType());
        tdxngsInputInvoiceEntity.setInvoiceType(mainEntity.getInvoiceType());
        tdxngsInputInvoiceEntity.setUuid(mainEntity.getUuid());
        tdxngsInputInvoiceEntity.setCreateTime(new Date());
        tdxngsInputInvoiceEntity.setUpdateTime(new Date());
        tdxngsInputInvoiceEntity.setGfTaxNo(mainEntity.getGfTaxNo());
        return tdxngsInputInvoiceEntity;
    }

    private String formatTaxCode(TDxRecordInvoiceEntity entity) {
        String invoiceType = entity.getInvoiceType();
        if (StringUtils.equals((CharSequence)entity.getFlowType(), (CharSequence)"6")) {
            return entity.getTaxCode();
        }
        if (StringUtils.equals((CharSequence)entity.getFlowType(), (CharSequence)"7")) {
            String orgType;
            String taxRate;
            TXfNoneBusinessUploadDetailEntity result = this.ngsMapper.getNoneBusResult(entity.getInvoiceNo(), entity.getInvoiceCode());
            if (null != result && StringUtils.isNotBlank((CharSequence)(taxRate = (String)StringUtils.defaultIfBlank((CharSequence)entity.getTaxRate().toString(), (CharSequence)result.getTaxRate())))) {
                BigDecimal decimal = new BigDecimal(taxRate);
                OptionEntity o = this.ngsMapper.queryNoneBusTaxRate(result.getBussinessType() + "_" + decimal.setScale(0, 0).toString());
                if (null != o) {
                    return o.getLabel();
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(orgType = this.ngsMapper.selectOrgType(entity.getXfTaxNo(), entity.getXfName()))) && orgType.equals("5") && entity.getTaxRate() != null && invoiceType != null) {
                String hostTaxRate = entity.getTaxRate().toString().substring(0, entity.getTaxRate().toString().indexOf(46));
                if (hostTaxRate.isEmpty()) {
                    return "";
                }
                String value = invoiceType + '_' + hostTaxRate;
                OptionEntity optionEntity = this.ngsMapper.queryHostTaxRate(value);
                if (optionEntity != null && optionEntity.getLabel() != null && StringUtils.isNotEmpty((CharSequence)optionEntity.getLabel())) {
                    return optionEntity.getLabel();
                }
                return "";
            }
        }
        if (StringUtils.equals((CharSequence)entity.getFlowType(), (CharSequence)"2")) {
            String uuid = entity.getInvoiceCode() + entity.getInvoiceNo();
            List costTaxCode = this.ngsMapper.getCostTaxCode(uuid);
            if (costTaxCode.size() > 0 && ObjectUtils.isEmpty((Object)entity.getTaxRate())) {
                ArrayList<String> listNew = new ArrayList<String>();
                String taxCode = "";
                for (OptionEntity oe : costTaxCode) {
                    if (listNew.contains(oe.getLabel())) continue;
                    listNew.add(oe.getLabel());
                }
                for (String taxCodes : listNew) {
                    taxCode = taxCode + taxCodes + ",";
                }
                if (!taxCode.equals("")) {
                    taxCode = taxCode.substring(0, taxCode.length() - 1);
                }
                return taxCode;
            }
            if (costTaxCode.size() > 0 && ((OptionEntity)costTaxCode.get(0)).getLabel() != null) {
                return ((OptionEntity)costTaxCode.get(0)).getLabel();
            }
            return "";
        }
        return "";
    }

    private String formatServiceType(TDxRecordInvoiceEntity entity) {
        String costServiceType;
        String uuid;
        List costTaxCode;
        if (StringUtils.equals((CharSequence)entity.getFlowType(), (CharSequence)"1")) {
            return "\u5546\u54c1\u4ed8\u6b3e\u7c7b";
        }
        if (StringUtils.equals((CharSequence)entity.getFlowType(), (CharSequence)"2") && (costTaxCode = this.ngsMapper.getCostTaxCode(uuid = entity.getInvoiceCode() + entity.getInvoiceNo())).size() > 0 && ((OptionEntity)costTaxCode.get(0)).getValue() != null && StringUtils.isNotEmpty((CharSequence)(costServiceType = ((OptionEntity)costTaxCode.get(0)).getCostTypeName()))) {
            return costServiceType;
        }
        if (StringUtils.equals((CharSequence)entity.getFlowType(), (CharSequence)"7")) {
            return "\u76f4\u63a5\u8ba4\u8bc1";
        }
        return "";
    }

    public BigDecimal formatBigdecimal(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            String replaceStr = str.replace(",", "");
            return new BigDecimal(replaceStr);
        }
        return new BigDecimal(0);
    }
}

