package com.xforceplus.xlog.apache.httpclient;

import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.MethodSignature;
import com.xforceplus.xlog.core.model.impl.HttpLogEvent;
import com.xforceplus.xlog.core.utils.JavassistUtil;
import javassist.Modifier;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

/**
 * ApacheClientPreparing
 *
 * @author gulei
 * @date 2024/08/14
 */
@Slf4j
public class XlogApacheClientPreparing {

    /**
     * 准备
     */
    public static void prepare() {
        final String mbClientClassName = "org.apache.http.impl.client.CloseableHttpClient";
        final String mbClientMethodName = "execute";

        final MethodSignature[] methodSignatures = new MethodSignature[]{
            new MethodSignature(mbClientMethodName, Modifier.PUBLIC, new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.protocol.HttpContext"}),
            new MethodSignature(mbClientMethodName, Modifier.PUBLIC, new String[]{"org.apache.http.client.methods.HttpUriRequest", "org.apache.http.protocol.HttpContext"}),
            new MethodSignature(mbClientMethodName, Modifier.PUBLIC, new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest"}),
        };

        try {
            final boolean result = JavassistUtil.installEventListener(mbClientClassName, methodSignatures, MethodEventListener.class, HttpLogEvent.class);

            if (result) {
                log.info(String.format("%s.%s 已完成字节码变更处理并载入到ClassLoader中...", mbClientClassName, mbClientMethodName));
            }
        } catch (Throwable e) {
            log.error(String.format("%s.%s 字节码变更失败...", mbClientClassName, mbClientMethodName), e);
        }
    }
}
