/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.apache.httpclient.model.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.google.common.collect.Sets;
import com.xforceplus.xlog.core.constant.RpcUserAgent;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.StandardResponseDTO;
import com.xforceplus.xlog.core.model.impl.RpcLogEvent;
import com.xforceplus.xlog.core.model.setting.XlogRpcSettings;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlogApacheClientListener
extends MethodEventListener {
    private static final Logger log = LoggerFactory.getLogger(XlogApacheClientListener.class);
    private static final Set<String> fileContentType = Sets.newHashSet((Object[])new String[]{"application/pdf", "image/jpeg", "image/jpg", "application/octet-stream", "image/png"});
    private final LogSender logSender;
    private final String storeName;
    private final XlogRpcSettings xlogRpcSettings;

    public XlogApacheClientListener(LogSender logSender, String storeName, @Nullable XlogRpcSettings xlogRpcSettings) {
        this.logSender = logSender;
        this.storeName = storeName;
        this.xlogRpcSettings = xlogRpcSettings;
    }

    public void beforeCall(Object target, LogEvent logEvent, Object[] args) {
        if (!(logEvent instanceof RpcLogEvent)) {
            return;
        }
        RpcLogEvent event = (RpcLogEvent)logEvent;
        String traceId = LogContext.getTraceId();
        event.setStoreName(this.storeName);
        event.setTraceId(traceId);
        event.setParentTraceId(LogContext.getParentTraceId());
        event.setUserAgent(RpcUserAgent.APACHE_CLIENT.toName());
        event.setTenantInfo(LogContext.getTenantInfo());
        if (this.xlogRpcSettings != null) {
            event.setLimitSize(this.xlogRpcSettings.getLimitSize());
        }
        try {
            if (args[0] instanceof HttpHost && args[1] instanceof HttpRequest) {
                this.processRequest((HttpHost)args[0], (HttpRequest)args[1], event);
            } else if (args[0] instanceof HttpUriRequest) {
                this.processRequest((HttpUriRequest)args[0], event);
            }
        }
        catch (Throwable ex) {
            event.setWarnMessage(String.format("[Before]\u6536\u96c6ApacheClient\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: %s", ExceptionUtil.toDesc((Throwable)ex)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object afterCall(Object target, LogEvent logEvent, Object[] args, Object result) {
        if (!(logEvent instanceof RpcLogEvent)) {
            return result;
        }
        RpcLogEvent event = (RpcLogEvent)logEvent;
        if (!(result instanceof CloseableHttpResponse)) {
            return result;
        }
        CloseableHttpResponse response = (CloseableHttpResponse)result;
        try {
            byte[] data;
            block16: {
                event.setResponseHeader(this.headers2String(response.getAllHeaders()));
                event.setHttpStatus(String.format("%d %s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                HttpEntity responseEntity = response.getEntity();
                if (responseEntity == null) {
                    Object object = result;
                    return object;
                }
                Optional.ofNullable(responseEntity.getContentType()).map(NameValuePair::getValue).ifPresent(arg_0 -> ((RpcLogEvent)event).setContentType(arg_0));
                data = EntityUtils.toByteArray((HttpEntity)responseEntity);
                event.setResponseSize(data.length);
                try {
                    if (event.getContentType() != null && fileContentType.stream().anyMatch(t -> event.getContentType().contains((CharSequence)t))) {
                        event.setResponseText(null);
                        break block16;
                    }
                    String responseText = new String(data, StandardCharsets.UTF_8);
                    event.setResponseText(responseText);
                    try {
                        StandardResponseDTO standardResponseDTO = (StandardResponseDTO)JSON.parseObject((String)responseText, StandardResponseDTO.class);
                        if (standardResponseDTO != null && StringUtils.isNotBlank((CharSequence)standardResponseDTO.getCode()) && this.xlogRpcSettings != null && this.xlogRpcSettings.getSuccessfulResponseCodes() != null) {
                            event.setSuccessful(this.xlogRpcSettings.getSuccessfulResponseCodes().contains(standardResponseDTO.getCode()));
                        }
                    }
                    catch (JSONException standardResponseDTO) {
                    }
                    catch (Exception ex) {
                        event.setWarnMessage("\u6839\u636eresponseCode\u8bbe\u7f6e\u65e5\u5fd7successful\u5c5e\u6027\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01" + ExceptionUtil.toDesc((Throwable)ex));
                        log.warn("\u6839\u636eresponseCode\u8bbe\u7f6e\u65e5\u5fd7successful\u5c5e\u6027\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)ex);
                    }
                }
                catch (Throwable e) {
                    event.setWarnMessage(String.format("\u8bb0\u5f55\u8fd4\u56de\u7ed3\u679c\u65f6\uff0c\u7f16\u7801\u8f6c\u6362\u5f02\u5e38\uff01%s", ExceptionUtil.toDesc((Throwable)e)));
                }
            }
            response.setEntity((HttpEntity)new ByteArrayEntity(data));
            CloseableHttpResponse closeableHttpResponse = response;
            return closeableHttpResponse;
        }
        catch (Throwable ex) {
            event.setWarnMessage("[After]\u6536\u96c6ApacheClient\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)ex));
            Object object = result;
            return object;
        }
        finally {
            this.logSender.send((LogEvent)event);
        }
    }

    public void onException(Object target, LogEvent logEvent, Throwable ex) {
        if (!(logEvent instanceof RpcLogEvent)) {
            return;
        }
        RpcLogEvent event = (RpcLogEvent)logEvent;
        event.setThrowable(ex);
        this.logSender.send((LogEvent)event);
    }

    public boolean shouldSkip(Object target, Object[] args) {
        try {
            if (args[0] instanceof HttpHost && args[1] instanceof HttpRequest) {
                String method = ((HttpRequest)args[1]).getRequestLine().getMethod();
                String baseUrl = ((HttpHost)args[0]).toURI();
                String path = ((HttpRequest)args[1]).getRequestLine().getUri();
                String url = path.startsWith("http") ? path : baseUrl + path;
                return this.matches(method, url);
            }
            if (args[0] instanceof HttpUriRequest) {
                String method = ((HttpUriRequest)args[0]).getMethod();
                String url = ((HttpUriRequest)args[0]).getURI().toURL().toString();
                return this.matches(method, url);
            }
            return false;
        }
        catch (Throwable throwable) {
            log.warn("[shouldSkip]ApacheClient\u5224\u65ad\u662f\u5426\u9700\u8981\u8df3\u8fc7\u65e5\u5fd7\u65f6\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable), throwable);
            return false;
        }
    }

    private void processRequest(HttpUriRequest httpUriRequest, RpcLogEvent event) {
        String url = httpUriRequest.getURI().toURL().toString();
        String method = httpUriRequest.getMethod();
        String path = httpUriRequest.getURI().getPath();
        Header[] headers = httpUriRequest.getAllHeaders();
        if (httpUriRequest instanceof HttpEntityEnclosingRequestBase) {
            this.processRequestEvent(event, (HttpEntityEnclosingRequestBase)httpUriRequest, method, url, path, headers);
        } else {
            this.processRequestEvent(event, null, method, url, path, headers);
        }
    }

    private void processRequest(HttpHost httpHost, HttpRequest httpRequest, RpcLogEvent event) {
        String baseUrl = httpHost.toURI();
        String method = httpRequest.getRequestLine().getMethod();
        String path = new URI(httpRequest.getRequestLine().getUri()).getPath();
        String url = baseUrl + httpRequest.getRequestLine().getUri();
        Header[] headers = httpRequest.getAllHeaders();
        if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            this.processRequestEvent(event, (HttpEntityEnclosingRequestBase)httpRequest, method, url, path, headers);
        } else {
            this.processRequestEvent(event, null, method, url, path, headers);
        }
    }

    private void processRequestEvent(RpcLogEvent event, HttpEntityEnclosingRequestBase entityRequest, String method, String url, String path, Header[] headers) throws IOException {
        HttpEntity entity;
        event.setMethod(method);
        event.setUrl(url);
        event.setName(path);
        event.setHeaders(this.headers2String(headers));
        if (entityRequest != null && (entity = entityRequest.getEntity()) != null) {
            byte[] data = EntityUtils.toByteArray((HttpEntity)entity);
            event.setRequestText(new String(data, StandardCharsets.UTF_8));
            event.setRequestSize(data.length);
            entityRequest.setEntity((HttpEntity)new ByteArrayEntity(data));
        }
    }

    private boolean matches(String method, String url) {
        if (url.contains("Xlog/LargeMessage") || url.contains("rmq-message")) {
            return true;
        }
        if (this.xlogRpcSettings == null || this.xlogRpcSettings.getBlackUrlPattern() == null) {
            return false;
        }
        return this.xlogRpcSettings.getBlackUrlPattern().matches(method, url);
    }

    private String headers2String(Header[] headers) {
        return Arrays.stream(headers).map(t -> t.getName() + ":" + t.getValue()).collect(Collectors.joining("\n"));
    }
}

