package com.xforceplus.xlog.elasticsearch;

import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.impl.ElasticsearchLogEvent;
import com.xforceplus.xlog.core.utils.JavassistUtil;
import javassist.Modifier;
import lombok.extern.slf4j.Slf4j;

/**
 * ElasticsearchPreparing
 *
 * @author gulei
 * @date 2024/03/20
 */
@Slf4j
public class ElasticsearchPreparing {
    public static void prepare() {
        final String className = "org.elasticsearch.client.RestClient";
        final String methodName = "performRequest";
        final Integer modifiers = Modifier.PUBLIC;

        try {
            final boolean result = JavassistUtil.installEventListener(className, methodName, modifiers, MethodEventListener.class, ElasticsearchLogEvent.class);

            if (result) {
                log.info(String.format("%s.%s 已完成字节码变更处理并载入到ClassLoader中...", className, methodName));
            }
        } catch (Throwable e) {
            log.error(String.format("%s.%s 字节码变更失败...", className, methodName), e);
        }
    }
}
