/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.elasticsearch.model.impl;

import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.impl.ElasticsearchLogEvent;
import com.xforceplus.xlog.core.model.setting.XlogElasticsearchSettings;
import com.xforceplus.xlog.core.model.setting.common.RequestText;
import com.xforceplus.xlog.core.model.setting.common.UriPattern;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;

public class XlogElasticsearchRestClientListenerImpl
extends MethodEventListener {
    private final LogSender logSender;
    private final String storeName;
    private final XlogElasticsearchSettings xlogElasticsearchSettings;

    public XlogElasticsearchRestClientListenerImpl(LogSender logSender, String storeName, @Nullable XlogElasticsearchSettings xlogElasticsearchSettings) {
        this.logSender = logSender;
        this.storeName = storeName;
        this.xlogElasticsearchSettings = xlogElasticsearchSettings;
    }

    public void beforeCall(Object target, LogEvent logEvent, Object[] args) {
        if (!(logEvent instanceof ElasticsearchLogEvent)) {
            return;
        }
        if (args.length < 1 || !(args[0] instanceof Request)) {
            return;
        }
        ElasticsearchLogEvent event = (ElasticsearchLogEvent)logEvent;
        String traceId = LogContext.getTraceId();
        event.setStoreName(this.storeName);
        event.setTraceId(traceId);
        event.setParentTraceId(LogContext.getParentTraceId());
        event.setTenantInfo(LogContext.getTenantInfo());
        Request request = (Request)args[0];
        try {
            UriPattern blackPathPattern;
            HttpEntity entity = request.getEntity();
            String endpoint = request.getEndpoint();
            event.setMethod(request.getMethod());
            if (StringUtils.isNotBlank((CharSequence)endpoint)) {
                event.setEndpoint(endpoint);
                String[] tokens = endpoint.split("/");
                event.setName(tokens.length == 0 ? endpoint : tokens[tokens.length - 1]);
                if (tokens.length > 2) {
                    event.setIndexCount(Integer.valueOf(StringUtils.countMatches((CharSequence)tokens[1], (char)',') + 1));
                }
            }
            if (!((blackPathPattern = (UriPattern)Optional.ofNullable(this.xlogElasticsearchSettings).map(XlogElasticsearchSettings::getRequestText).map(RequestText::getBlackPathPattern).orElse(null)) != null && blackPathPattern.matches(request.getMethod(), endpoint) || entity == null || !entity.isRepeatable() || entity.isStreaming())) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                entity.writeTo((OutputStream)out);
                event.setRequestText(out.toString());
                event.setRequestSize(out.size());
            }
        }
        catch (Throwable ex) {
            event.setWarnMessage(String.format("[Before]\u6536\u96c6Elasticsearch[RestClient]\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: %s", ExceptionUtil.toDesc((Throwable)ex)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object afterCall(Object target, LogEvent logEvent, Object[] args, Object result) {
        if (!(logEvent instanceof ElasticsearchLogEvent)) {
            return result;
        }
        if (!(result instanceof Response)) {
            return result;
        }
        ElasticsearchLogEvent event = (ElasticsearchLogEvent)logEvent;
        Response originalResponse = (Response)result;
        try {
            StatusLine statusLine = originalResponse.getStatusLine();
            event.setHttpStatus(statusLine.getStatusCode() + "");
            Object object = result;
            return object;
        }
        catch (Throwable ex) {
            event.setWarnMessage("[After]\u6536\u96c6Elasticsearch[RestClient]\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)ex));
            event.setThrowable(ex);
            Object object = result;
            return object;
        }
        finally {
            this.logSender.send((LogEvent)event);
        }
    }

    public void onException(Object target, LogEvent logEvent, Throwable ex) {
        if (!(logEvent instanceof ElasticsearchLogEvent)) {
            return;
        }
        ElasticsearchLogEvent event = (ElasticsearchLogEvent)logEvent;
        event.setThrowable(ex);
        this.logSender.send(logEvent);
    }
}

