package com.xforceplus.xlog.janus;

import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.impl.JanusProducerLogEvent;
import com.xforceplus.xlog.core.utils.JavassistUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * @author zhuxingsheng@gmail.com
 * @description: 集成平台准备
 * @date 2023/11/2 11:31
 */
@Slf4j
public class JanusPreparing {

    private JanusPreparing() {
        throw new IllegalStateException("Utility class");
    }

    /**
     * 准备
     */
    public static void prepare() {
        final String mcClientClassName = "com.xforceplus.apollo.client.netty.MCFactory";
        final String mcClientMethodName = "sendMessage";

        try {
            final boolean result = JavassistUtil.installEventListener(mcClientClassName, mcClientMethodName, MethodEventListener.class, JanusProducerLogEvent.class);

            if (result) {
                log.info(String.format("%s.%s 已完成字节码变更处理并载入到ClassLoader中...", mcClientClassName, mcClientMethodName));
            }
        } catch (final Throwable e) {
            log.error(String.format("%s.%s 字节码变更失败...", mcClientClassName, mcClientMethodName), e);
        }
    }

}
